/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.config.provider;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.config.ConfigData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.config.ConfigException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.config.provider.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryConfigProvider
implements ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(DirectoryConfigProvider.class);

    @Override
    public void configure(Map<String, ?> configs) {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public ConfigData get(String path) {
        return DirectoryConfigProvider.get(path, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
    }

    @Override
    public ConfigData get(String path, Set<String> keys) {
        return DirectoryConfigProvider.get(path, pathname -> Files.isRegularFile(pathname, new LinkOption[0]) && keys.contains(pathname.getFileName().toString()));
    }

    private static ConfigData get(String path, Predicate<Path> fileFilter) {
        Map<String, String> map = Collections.emptyMap();
        if (path != null && !path.isEmpty()) {
            Path dir = new File(path).toPath();
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                log.warn("The path {} is not a directory", (Object)path);
            } else {
                try (Stream<Path> stream = Files.list(dir);){
                    map = stream.filter(fileFilter).collect(Collectors.toMap(p -> p.getFileName().toString(), p -> DirectoryConfigProvider.read(p)));
                }
                catch (IOException e) {
                    log.error("Could not list directory {}", (Object)dir, (Object)e);
                    throw new ConfigException("Could not list directory " + dir);
                }
            }
        }
        return new ConfigData(map);
    }

    private static String read(Path path) {
        try {
            return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Could not read file {} for property {}", new Object[]{path, path.getFileName(), e});
            throw new ConfigException("Could not read file " + path + " for property " + path.getFileName());
        }
    }
}

