/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicIdPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Uuid;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.FetchMetadata;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.FetchRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.FetchResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.LogContext;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public class FetchSessionHandler {
    private final Logger log;
    private final int node;
    private FetchMetadata nextMetadata = FetchMetadata.INITIAL;
    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> sessionPartitions = new LinkedHashMap(0);
    private Map<Uuid, String> sessionTopicNames = new HashMap<Uuid, String>(0);

    public FetchSessionHandler(LogContext logContext, int node) {
        this.log = logContext.logger(FetchSessionHandler.class);
        this.node = node;
    }

    public Map<Uuid, String> sessionTopicNames() {
        return this.sessionTopicNames;
    }

    public Builder newBuilder() {
        return new Builder();
    }

    public Builder newBuilder(int size, boolean copySessionPartitions) {
        return new Builder(size, copySessionPartitions);
    }

    private String topicPartitionsToLogString(Collection<TopicPartition> partitions) {
        if (!this.log.isTraceEnabled()) {
            return String.format("%d partition(s)", partitions.size());
        }
        return "(" + Utils.join(partitions, ", ") + ")";
    }

    private String topicIdPartitionsToLogString(Collection<TopicIdPartition> partitions) {
        if (!this.log.isTraceEnabled()) {
            return String.format("%d partition(s)", partitions.size());
        }
        return "(" + Utils.join(partitions, ", ") + ")";
    }

    static <T> Set<T> findMissing(Set<T> toFind, Set<T> toSearch) {
        LinkedHashSet<T> ret = new LinkedHashSet<T>();
        for (T toFindItem : toFind) {
            if (toSearch.contains(toFindItem)) continue;
            ret.add(toFindItem);
        }
        return ret;
    }

    String verifyFullFetchResponsePartitions(Set<TopicPartition> topicPartitions, Set<Uuid> ids, short version) {
        StringBuilder bld = new StringBuilder();
        Set<TopicPartition> extra = FetchSessionHandler.findMissing(topicPartitions, this.sessionPartitions.keySet());
        Set<TopicPartition> omitted = FetchSessionHandler.findMissing(this.sessionPartitions.keySet(), topicPartitions);
        Set<Object> extraIds = new HashSet();
        if (version >= 13) {
            extraIds = FetchSessionHandler.findMissing(ids, this.sessionTopicNames.keySet());
        }
        if (!omitted.isEmpty()) {
            bld.append("omittedPartitions=(").append(Utils.join(omitted, ", ")).append(", ");
        }
        if (!extra.isEmpty()) {
            bld.append("extraPartitions=(").append(Utils.join(extra, ", ")).append(", ");
        }
        if (!extraIds.isEmpty()) {
            bld.append("extraIds=(").append(Utils.join(extraIds, ", ")).append(", ");
        }
        if (!(omitted.isEmpty() && extra.isEmpty() && extraIds.isEmpty())) {
            bld.append("response=(").append(Utils.join(topicPartitions, ", ")).append(")");
            return bld.toString();
        }
        return null;
    }

    String verifyIncrementalFetchResponsePartitions(Set<TopicPartition> topicPartitions, Set<Uuid> ids, short version) {
        Set<Object> extraIds = new HashSet();
        if (version >= 13) {
            extraIds = FetchSessionHandler.findMissing(ids, this.sessionTopicNames.keySet());
        }
        Set<TopicPartition> extra = FetchSessionHandler.findMissing(topicPartitions, this.sessionPartitions.keySet());
        StringBuilder bld = new StringBuilder();
        if (!extra.isEmpty()) {
            bld.append("extraPartitions=(").append(Utils.join(extra, ", ")).append("), ");
        }
        if (!extraIds.isEmpty()) {
            bld.append("extraIds=(").append(Utils.join(extraIds, ", ")).append("), ");
        }
        if (!extra.isEmpty() || !extraIds.isEmpty()) {
            bld.append("response=(").append(Utils.join(topicPartitions, ", ")).append(")");
            return bld.toString();
        }
        return null;
    }

    private String responseDataToLogString(Set<TopicPartition> topicPartitions) {
        if (!this.log.isTraceEnabled()) {
            int implied = this.sessionPartitions.size() - topicPartitions.size();
            if (implied > 0) {
                return String.format(" with %d response partition(s), %d implied partition(s)", topicPartitions.size(), implied);
            }
            return String.format(" with %d response partition(s)", topicPartitions.size());
        }
        StringBuilder bld = new StringBuilder();
        bld.append(" with response=(").append(Utils.join(topicPartitions, ", ")).append(")");
        String prefix = ", implied=(";
        String suffix = "";
        for (TopicPartition partition : this.sessionPartitions.keySet()) {
            if (topicPartitions.contains(partition)) continue;
            bld.append(prefix);
            bld.append(partition);
            prefix = ", ";
            suffix = ")";
        }
        bld.append(suffix);
        return bld.toString();
    }

    public boolean handleResponse(FetchResponse response, short version) {
        if (response.error() != Errors.NONE) {
            this.log.info("Node {} was unable to process the fetch request with {}: {}.", new Object[]{this.node, this.nextMetadata, response.error()});
            this.nextMetadata = response.error() == Errors.FETCH_SESSION_ID_NOT_FOUND ? FetchMetadata.INITIAL : this.nextMetadata.nextCloseExisting();
            return false;
        }
        Set<TopicPartition> topicPartitions = response.responseData(this.sessionTopicNames, version).keySet();
        if (this.nextMetadata.isFull()) {
            if (topicPartitions.isEmpty() && response.throttleTimeMs() > 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Node {} sent a empty full fetch response to indicate that this client should be throttled for {} ms.", (Object)this.node, (Object)response.throttleTimeMs());
                }
                this.nextMetadata = FetchMetadata.INITIAL;
                return false;
            }
            String problem = this.verifyFullFetchResponsePartitions(topicPartitions, response.topicIds(), version);
            if (problem != null) {
                this.log.info("Node {} sent an invalid full fetch response with {}", (Object)this.node, (Object)problem);
                this.nextMetadata = FetchMetadata.INITIAL;
                return false;
            }
            if (response.sessionId() == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Node {} sent a full fetch response{}", (Object)this.node, (Object)this.responseDataToLogString(topicPartitions));
                }
                this.nextMetadata = FetchMetadata.INITIAL;
                return true;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Node {} sent a full fetch response that created a new incremental fetch session {}{}", new Object[]{this.node, response.sessionId(), this.responseDataToLogString(topicPartitions)});
            }
            this.nextMetadata = FetchMetadata.newIncremental(response.sessionId());
            return true;
        }
        String problem = this.verifyIncrementalFetchResponsePartitions(topicPartitions, response.topicIds(), version);
        if (problem != null) {
            this.log.info("Node {} sent an invalid incremental fetch response with {}", (Object)this.node, (Object)problem);
            this.nextMetadata = this.nextMetadata.nextCloseExisting();
            return false;
        }
        if (response.sessionId() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Node {} sent an incremental fetch response closing session {}{}", new Object[]{this.node, this.nextMetadata.sessionId(), this.responseDataToLogString(topicPartitions)});
            }
            this.nextMetadata = FetchMetadata.INITIAL;
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Node {} sent an incremental fetch response with throttleTimeMs = {} for session {}{}", new Object[]{this.node, response.throttleTimeMs(), response.sessionId(), this.responseDataToLogString(topicPartitions)});
        }
        this.nextMetadata = this.nextMetadata.nextIncremental();
        return true;
    }

    public void handleError(Throwable t) {
        this.log.info("Error sending fetch request {} to node {}:", new Object[]{this.nextMetadata, this.node, t});
        this.nextMetadata = this.nextMetadata.nextCloseExisting();
    }

    public class Builder {
        private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> next;
        private Map<Uuid, String> topicNames;
        private final boolean copySessionPartitions;
        private int partitionsWithoutTopicIds = 0;

        Builder() {
            this.next = new LinkedHashMap();
            this.topicNames = new HashMap<Uuid, String>();
            this.copySessionPartitions = true;
        }

        Builder(int initialSize, boolean copySessionPartitions) {
            this.next = new LinkedHashMap(initialSize);
            this.topicNames = new HashMap<Uuid, String>();
            this.copySessionPartitions = copySessionPartitions;
        }

        public void add(TopicPartition topicPartition, FetchRequest.PartitionData data) {
            this.next.put(topicPartition, data);
            if (data.topicId.equals(Uuid.ZERO_UUID)) {
                ++this.partitionsWithoutTopicIds;
            } else {
                this.topicNames.putIfAbsent(data.topicId, topicPartition.topic());
            }
        }

        public FetchRequestData build() {
            TopicPartition topicPartition;
            boolean canUseTopicIds;
            boolean bl = canUseTopicIds = this.partitionsWithoutTopicIds == 0;
            if (FetchSessionHandler.this.nextMetadata.isFull()) {
                if (FetchSessionHandler.this.log.isDebugEnabled()) {
                    FetchSessionHandler.this.log.debug("Built full fetch {} for node {} with {}.", new Object[]{FetchSessionHandler.this.nextMetadata, FetchSessionHandler.this.node, FetchSessionHandler.this.topicPartitionsToLogString(this.next.keySet())});
                }
                FetchSessionHandler.this.sessionPartitions = this.next;
                this.next = null;
                if (canUseTopicIds) {
                    FetchSessionHandler.this.sessionTopicNames = this.topicNames;
                } else {
                    FetchSessionHandler.this.sessionTopicNames = Collections.emptyMap();
                }
                Map<TopicPartition, FetchRequest.PartitionData> toSend = Collections.unmodifiableMap(new LinkedHashMap(FetchSessionHandler.this.sessionPartitions));
                return new FetchRequestData(toSend, Collections.emptyList(), Collections.emptyList(), toSend, FetchSessionHandler.this.nextMetadata, canUseTopicIds);
            }
            ArrayList<TopicIdPartition> added = new ArrayList<TopicIdPartition>();
            ArrayList<TopicIdPartition> removed = new ArrayList<TopicIdPartition>();
            ArrayList<TopicIdPartition> altered = new ArrayList<TopicIdPartition>();
            ArrayList<TopicIdPartition> replaced = new ArrayList<TopicIdPartition>();
            Iterator<Map.Entry<Object, Object>> iter = FetchSessionHandler.this.sessionPartitions.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                topicPartition = (TopicPartition)entry.getKey();
                FetchRequest.PartitionData prevData = (FetchRequest.PartitionData)entry.getValue();
                FetchRequest.PartitionData nextData = (FetchRequest.PartitionData)this.next.remove(topicPartition);
                if (nextData != null) {
                    if (!(prevData.topicId.equals(nextData.topicId) || prevData.topicId.equals(Uuid.ZERO_UUID) || nextData.topicId.equals(Uuid.ZERO_UUID))) {
                        this.next.put(topicPartition, nextData);
                        entry.setValue(nextData);
                        replaced.add(new TopicIdPartition(prevData.topicId, topicPartition));
                        continue;
                    }
                    if (prevData.equals(nextData)) continue;
                    this.next.put(topicPartition, nextData);
                    entry.setValue(nextData);
                    altered.add(new TopicIdPartition(nextData.topicId, topicPartition));
                    continue;
                }
                iter.remove();
                removed.add(new TopicIdPartition(prevData.topicId, topicPartition));
                if (!canUseTopicIds || !prevData.topicId.equals(Uuid.ZERO_UUID)) continue;
                canUseTopicIds = false;
            }
            for (Map.Entry<Object, Object> entry : this.next.entrySet()) {
                topicPartition = (TopicPartition)entry.getKey();
                FetchRequest.PartitionData nextData = (FetchRequest.PartitionData)entry.getValue();
                if (FetchSessionHandler.this.sessionPartitions.containsKey(topicPartition)) break;
                FetchSessionHandler.this.sessionPartitions.put(topicPartition, nextData);
                added.add(new TopicIdPartition(nextData.topicId, topicPartition));
            }
            if (canUseTopicIds) {
                FetchSessionHandler.this.sessionTopicNames = this.topicNames;
            } else {
                FetchSessionHandler.this.sessionTopicNames = Collections.emptyMap();
            }
            if (FetchSessionHandler.this.log.isDebugEnabled()) {
                FetchSessionHandler.this.log.debug("Built incremental fetch {} for node {}. Added {}, altered {}, removed {}, replaced {} out of {}", new Object[]{FetchSessionHandler.this.nextMetadata, FetchSessionHandler.this.node, FetchSessionHandler.this.topicIdPartitionsToLogString(added), FetchSessionHandler.this.topicIdPartitionsToLogString(altered), FetchSessionHandler.this.topicIdPartitionsToLogString(removed), FetchSessionHandler.this.topicIdPartitionsToLogString(replaced), FetchSessionHandler.this.topicPartitionsToLogString(FetchSessionHandler.this.sessionPartitions.keySet())});
            }
            Map<TopicPartition, FetchRequest.PartitionData> toSend = Collections.unmodifiableMap(this.next);
            Map<TopicPartition, FetchRequest.PartitionData> map = this.copySessionPartitions ? Collections.unmodifiableMap(new LinkedHashMap(FetchSessionHandler.this.sessionPartitions)) : Collections.unmodifiableMap(FetchSessionHandler.this.sessionPartitions);
            this.next = null;
            return new FetchRequestData(toSend, Collections.unmodifiableList(removed), Collections.unmodifiableList(replaced), map, FetchSessionHandler.this.nextMetadata, canUseTopicIds);
        }
    }

    public static class FetchRequestData {
        private final Map<TopicPartition, FetchRequest.PartitionData> toSend;
        private final List<TopicIdPartition> toForget;
        private final List<TopicIdPartition> toReplace;
        private final Map<TopicPartition, FetchRequest.PartitionData> sessionPartitions;
        private final FetchMetadata metadata;
        private final boolean canUseTopicIds;

        FetchRequestData(Map<TopicPartition, FetchRequest.PartitionData> toSend, List<TopicIdPartition> toForget, List<TopicIdPartition> toReplace, Map<TopicPartition, FetchRequest.PartitionData> sessionPartitions, FetchMetadata metadata, boolean canUseTopicIds) {
            this.toSend = toSend;
            this.toForget = toForget;
            this.toReplace = toReplace;
            this.sessionPartitions = sessionPartitions;
            this.metadata = metadata;
            this.canUseTopicIds = canUseTopicIds;
        }

        public Map<TopicPartition, FetchRequest.PartitionData> toSend() {
            return this.toSend;
        }

        public List<TopicIdPartition> toForget() {
            return this.toForget;
        }

        public List<TopicIdPartition> toReplace() {
            return this.toReplace;
        }

        public Map<TopicPartition, FetchRequest.PartitionData> sessionPartitions() {
            return this.sessionPartitions;
        }

        public FetchMetadata metadata() {
            return this.metadata;
        }

        public boolean canUseTopicIds() {
            return this.canUseTopicIds;
        }

        public String toString() {
            StringBuilder bld;
            if (this.metadata.isFull()) {
                bld = new StringBuilder("FullFetchRequest(toSend=(");
                String prefix = "";
                for (TopicPartition topicPartition : this.toSend.keySet()) {
                    bld.append(prefix);
                    bld.append(topicPartition);
                    prefix = ", ";
                }
            } else {
                bld = new StringBuilder("IncrementalFetchRequest(toSend=(");
                String prefix = "";
                for (TopicPartition topicPartition : this.toSend.keySet()) {
                    bld.append(prefix);
                    bld.append(topicPartition);
                    prefix = ", ";
                }
                bld.append("), toForget=(");
                prefix = "";
                for (TopicIdPartition topicIdPartition : this.toForget) {
                    bld.append(prefix);
                    bld.append(topicIdPartition);
                    prefix = ", ";
                }
                bld.append("), toReplace=(");
                prefix = "";
                for (TopicIdPartition topicIdPartition : this.toReplace) {
                    bld.append(prefix);
                    bld.append(topicIdPartition);
                    prefix = ", ";
                }
                bld.append("), implied=(");
                prefix = "";
                for (TopicPartition topicPartition : this.sessionPartitions.keySet()) {
                    if (this.toSend.containsKey(topicPartition)) continue;
                    bld.append(prefix);
                    bld.append(topicPartition);
                    prefix = ", ";
                }
            }
            if (this.canUseTopicIds) {
                bld.append("), canUseTopicIds=True");
            } else {
                bld.append("), canUseTopicIds=False");
            }
            bld.append(")");
            return bld.toString();
        }
    }
}

