/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator.initializer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.connector.kafka.source.enumerator.initializer.OffsetsInitializer;
import org.apache.flink.connector.kafka.source.enumerator.initializer.OffsetsInitializerValidator;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.util.Preconditions;

class ReaderHandledOffsetsInitializer
implements OffsetsInitializer,
OffsetsInitializerValidator {
    private static final long serialVersionUID = 172938052008787981L;
    private final long startingOffset;
    private final OffsetResetStrategy offsetResetStrategy;

    ReaderHandledOffsetsInitializer(long startingOffset, OffsetResetStrategy offsetResetStrategy) {
        this.startingOffset = startingOffset;
        this.offsetResetStrategy = offsetResetStrategy;
    }

    @Override
    public Map<TopicPartition, Long> getPartitionOffsets(Collection<TopicPartition> partitions, OffsetsInitializer.PartitionOffsetsRetriever partitionOffsetsRetriever) {
        HashMap<TopicPartition, Long> initialOffsets = new HashMap<TopicPartition, Long>();
        for (TopicPartition tp : partitions) {
            initialOffsets.put(tp, this.startingOffset);
        }
        return initialOffsets;
    }

    @Override
    public OffsetResetStrategy getAutoOffsetResetStrategy() {
        return this.offsetResetStrategy;
    }

    @Override
    public void validate(Properties kafkaSourceProperties) {
        if (this.startingOffset == -3L) {
            Preconditions.checkState((boolean)kafkaSourceProperties.containsKey("group.id"), (Object)String.format("Property %s is required when using committed offset for offsets initializer", "group.id"));
        }
    }
}

