/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.table;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.serialization.RuntimeContextInitializationContextAdapters;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.delete.DeleteRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.index.IndexRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.update.UpdateRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchSinkFunction;
import org.apache.flink.streaming.connectors.elasticsearch.RequestIndexer;
import org.apache.flink.streaming.connectors.elasticsearch.table.IndexGenerator;
import org.apache.flink.streaming.connectors.elasticsearch.table.RequestFactory;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;

@Internal
class RowElasticsearchSinkFunction
implements ElasticsearchSinkFunction<RowData> {
    private static final long serialVersionUID = 1L;
    private final IndexGenerator indexGenerator;
    private final String docType;
    private final SerializationSchema<RowData> serializationSchema;
    private final XContentType contentType;
    private final RequestFactory requestFactory;
    private final Function<RowData, String> createKey;

    public RowElasticsearchSinkFunction(IndexGenerator indexGenerator, @Nullable String docType, SerializationSchema<RowData> serializationSchema, XContentType contentType, RequestFactory requestFactory, Function<RowData, String> createKey) {
        this.indexGenerator = (IndexGenerator)Preconditions.checkNotNull((Object)indexGenerator);
        this.docType = docType;
        this.serializationSchema = (SerializationSchema)Preconditions.checkNotNull(serializationSchema);
        this.contentType = (XContentType)((Object)Preconditions.checkNotNull((Object)((Object)contentType)));
        this.requestFactory = (RequestFactory)Preconditions.checkNotNull((Object)requestFactory);
        this.createKey = (Function)Preconditions.checkNotNull(createKey);
    }

    @Override
    public void open(RuntimeContext ctx) throws Exception {
        this.serializationSchema.open(RuntimeContextInitializationContextAdapters.serializationAdapter((RuntimeContext)ctx));
        this.indexGenerator.open();
    }

    @Override
    public void process(RowData element, RuntimeContext ctx, RequestIndexer indexer) {
        switch (element.getRowKind()) {
            case INSERT: 
            case UPDATE_AFTER: {
                this.processUpsert(element, indexer);
                break;
            }
            case UPDATE_BEFORE: 
            case DELETE: {
                this.processDelete(element, indexer);
                break;
            }
            default: {
                throw new TableException("Unsupported message kind: " + element.getRowKind());
            }
        }
    }

    private void processUpsert(RowData row, RequestIndexer indexer) {
        byte[] document = this.serializationSchema.serialize((Object)row);
        String key = this.createKey.apply(row);
        if (key != null) {
            UpdateRequest updateRequest = this.requestFactory.createUpdateRequest(this.indexGenerator.generate(row), this.docType, key, this.contentType, document);
            indexer.add(updateRequest);
        } else {
            IndexRequest indexRequest = this.requestFactory.createIndexRequest(this.indexGenerator.generate(row), this.docType, key, this.contentType, document);
            indexer.add(indexRequest);
        }
    }

    private void processDelete(RowData row, RequestIndexer indexer) {
        String key = this.createKey.apply(row);
        DeleteRequest deleteRequest = this.requestFactory.createDeleteRequest(this.indexGenerator.generate(row), this.docType, key);
        indexer.add(deleteRequest);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowElasticsearchSinkFunction that = (RowElasticsearchSinkFunction)o;
        return Objects.equals(this.indexGenerator, that.indexGenerator) && Objects.equals(this.docType, that.docType) && Objects.equals(this.serializationSchema, that.serializationSchema) && this.contentType == that.contentType && Objects.equals(this.requestFactory, that.requestFactory) && Objects.equals(this.createKey, that.createKey);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.indexGenerator, this.docType, this.serializationSchema, this.contentType, this.requestFactory, this.createKey});
    }
}

