/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.IntArrayList;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.IndicesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.OriginalIndices;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.RescoreDocIds;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.dfs.AggregatedDfs;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.ShardFetchRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.ShardSearchContextId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.ShardSearchRequest;

public class ShardFetchSearchRequest
extends ShardFetchRequest
implements IndicesRequest {
    private final OriginalIndices originalIndices;
    private final ShardSearchRequest shardSearchRequest;
    private final RescoreDocIds rescoreDocIds;
    private final AggregatedDfs aggregatedDfs;

    public ShardFetchSearchRequest(OriginalIndices originalIndices, ShardSearchContextId id, ShardSearchRequest shardSearchRequest, IntArrayList list, ScoreDoc lastEmittedDoc, RescoreDocIds rescoreDocIds, AggregatedDfs aggregatedDfs) {
        super(id, list, lastEmittedDoc);
        this.originalIndices = originalIndices;
        this.shardSearchRequest = shardSearchRequest;
        this.rescoreDocIds = rescoreDocIds;
        this.aggregatedDfs = aggregatedDfs;
    }

    public ShardFetchSearchRequest(StreamInput in) throws IOException {
        super(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
        if (in.getVersion().onOrAfter(Version.V_7_10_0)) {
            this.shardSearchRequest = in.readOptionalWriteable(ShardSearchRequest::new);
            this.rescoreDocIds = new RescoreDocIds(in);
            this.aggregatedDfs = in.readOptionalWriteable(AggregatedDfs::new);
        } else {
            this.shardSearchRequest = null;
            this.rescoreDocIds = RescoreDocIds.EMPTY;
            this.aggregatedDfs = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeOptionalWriteable(this.shardSearchRequest);
            this.rescoreDocIds.writeTo(out);
            out.writeOptionalWriteable(this.aggregatedDfs);
        }
    }

    @Override
    public String[] indices() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indicesOptions();
    }

    @Override
    public ShardSearchRequest getShardSearchRequest() {
        return this.shardSearchRequest;
    }

    @Override
    public RescoreDocIds getRescoreDocIds() {
        return this.rescoreDocIds;
    }

    @Override
    public AggregatedDfs getAggregatedDfs() {
        return this.aggregatedDfs;
    }
}

