/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.collapse;

import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.grouping.CollapsingTopDocsCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.NumberFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.InnerHitBuilder;

public class CollapseContext {
    private final String fieldName;
    private final MappedFieldType fieldType;
    private final List<InnerHitBuilder> innerHits;

    public CollapseContext(String fieldName, MappedFieldType fieldType, List<InnerHitBuilder> innerHits) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.innerHits = innerHits;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public MappedFieldType getFieldType() {
        return this.fieldType;
    }

    public List<InnerHitBuilder> getInnerHit() {
        return this.innerHits;
    }

    public CollapsingTopDocsCollector<?> createTopDocs(Sort sort, int topN) {
        if (this.fieldType instanceof KeywordFieldMapper.KeywordFieldType) {
            return CollapsingTopDocsCollector.createKeyword(this.fieldName, this.fieldType, sort, topN);
        }
        if (this.fieldType instanceof NumberFieldMapper.NumberFieldType) {
            return CollapsingTopDocsCollector.createNumeric(this.fieldName, this.fieldType, sort, topN);
        }
        throw new IllegalStateException("unknown type for collapse field " + this.fieldName + ", only keywords and numbers are accepted");
    }
}

