/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.BucketMetricsPipelineAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;

public class SumBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private double sum = 0.0;

    SumBucketPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, bucketsPaths, gapPolicy, formatter, metadata);
    }

    public SumBucketPipelineAggregator(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return "sum_bucket";
    }

    @Override
    protected void preCollection() {
        this.sum = 0.0;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        this.sum += bucketValue.doubleValue();
    }

    @Override
    protected InternalAggregation buildAggregation(Map<String, Object> metadata) {
        return new InternalSimpleValue(this.name(), this.sum, this.format, metadata);
    }
}

