/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.ParsedAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.ValueCount;

public class ParsedValueCount
extends ParsedAggregation
implements ValueCount {
    private long valueCount;
    private static final ObjectParser<ParsedValueCount, Void> PARSER = new ObjectParser(ParsedValueCount.class.getSimpleName(), true, ParsedValueCount::new);

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public long getValue() {
        return this.valueCount;
    }

    @Override
    public String getValueAsString() {
        return Double.toString(this.valueCount);
    }

    @Override
    public String getType() {
        return "value_count";
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.valueCount);
        return builder;
    }

    public static ParsedValueCount fromXContent(XContentParser parser, String name) {
        ParsedValueCount sum = PARSER.apply(parser, null);
        sum.setName(name);
        return sum;
    }

    static {
        ParsedValueCount.declareAggregationFields(PARSER);
        PARSER.declareLong((agg, value) -> {
            agg.valueCount = value;
        }, Aggregation.CommonFields.VALUE);
    }
}

