/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MultiTermQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.RegexpQuery;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.BytesRefs;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.AbstractQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.RegexpFlag;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.support.QueryParsers;

public class RegexpQueryBuilder
extends AbstractQueryBuilder<RegexpQueryBuilder>
implements MultiTermQueryBuilder {
    public static final String NAME = "regexp";
    public static final int DEFAULT_FLAGS_VALUE = RegexpFlag.ALL.value();
    public static final int DEFAULT_MAX_DETERMINIZED_STATES = 10000;
    public static final boolean DEFAULT_CASE_INSENSITIVITY = false;
    private static final ParseField FLAGS_VALUE_FIELD = new ParseField("flags_value", new String[0]);
    private static final ParseField MAX_DETERMINIZED_STATES_FIELD = new ParseField("max_determinized_states", new String[0]);
    private static final ParseField FLAGS_FIELD = new ParseField("flags", new String[0]);
    private static final ParseField CASE_INSENSITIVE_FIELD = new ParseField("case_insensitive", new String[0]);
    private static final ParseField REWRITE_FIELD = new ParseField("rewrite", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private final String fieldName;
    private final String value;
    private int syntaxFlagsValue = DEFAULT_FLAGS_VALUE;
    private boolean caseInsensitive = false;
    private int maxDeterminizedStates = 10000;
    private String rewrite;

    public RegexpQueryBuilder(String fieldName, String value) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.fieldName = fieldName;
        this.value = value;
    }

    public RegexpQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.value = in.readString();
        this.syntaxFlagsValue = in.readVInt();
        this.maxDeterminizedStates = in.readVInt();
        this.rewrite = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_7_10_0)) {
            this.caseInsensitive = in.readBoolean();
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeString(this.value);
        out.writeVInt(this.syntaxFlagsValue);
        out.writeVInt(this.maxDeterminizedStates);
        out.writeOptionalString(this.rewrite);
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeBoolean(this.caseInsensitive);
        }
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public String value() {
        return this.value;
    }

    public RegexpQueryBuilder flags(RegexpFlag ... flags) {
        if (flags == null) {
            this.syntaxFlagsValue = DEFAULT_FLAGS_VALUE;
            return this;
        }
        int value = 0;
        if (flags.length == 0) {
            value = RegexpFlag.ALL.value;
        } else {
            for (RegexpFlag flag : flags) {
                value |= flag.value;
            }
        }
        this.syntaxFlagsValue = value;
        return this;
    }

    public RegexpQueryBuilder flags(int flags) {
        this.syntaxFlagsValue = flags;
        return this;
    }

    public int flags() {
        return this.syntaxFlagsValue;
    }

    public RegexpQueryBuilder caseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        return this;
    }

    public boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    public RegexpQueryBuilder maxDeterminizedStates(int value) {
        this.maxDeterminizedStates = value;
        return this;
    }

    public int maxDeterminizedStates() {
        return this.maxDeterminizedStates;
    }

    public RegexpQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    public String rewrite() {
        return this.rewrite;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(VALUE_FIELD.getPreferredName(), this.value);
        builder.field(FLAGS_VALUE_FIELD.getPreferredName(), this.syntaxFlagsValue);
        if (this.caseInsensitive) {
            builder.field(CASE_INSENSITIVE_FIELD.getPreferredName(), this.caseInsensitive);
        }
        builder.field(MAX_DETERMINIZED_STATES_FIELD.getPreferredName(), this.maxDeterminizedStates);
        if (this.rewrite != null) {
            builder.field(REWRITE_FIELD.getPreferredName(), this.rewrite);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static RegexpQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        String rewrite = null;
        String value = null;
        float boost = 1.0f;
        int flagsValue = DEFAULT_FLAGS_VALUE;
        boolean caseInsensitive = false;
        int maxDeterminizedStates = 10000;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                RegexpQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (VALUE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        value = parser.textOrNull();
                        continue;
                    }
                    if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if (REWRITE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        rewrite = parser.textOrNull();
                        continue;
                    }
                    if (FLAGS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        String flags = parser.textOrNull();
                        flagsValue = RegexpFlag.resolveValue(flags);
                        continue;
                    }
                    if (MAX_DETERMINIZED_STATES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        maxDeterminizedStates = parser.intValue();
                        continue;
                    }
                    if (FLAGS_VALUE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        flagsValue = parser.intValue();
                        continue;
                    }
                    if (CASE_INSENSITIVE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        caseInsensitive = parser.booleanValue();
                        continue;
                    }
                    if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[regexp] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            RegexpQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
            fieldName = currentFieldName;
            value = parser.textOrNull();
        }
        RegexpQueryBuilder result = (RegexpQueryBuilder)((RegexpQueryBuilder)new RegexpQueryBuilder(fieldName, value).flags(flagsValue).maxDeterminizedStates(maxDeterminizedStates).rewrite(rewrite).boost(boost)).queryName(queryName);
        result.caseInsensitive(caseInsensitive);
        return result;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws QueryShardException, IOException {
        int maxAllowedRegexLength = context.getIndexSettings().getMaxRegexLength();
        if (this.value.length() > maxAllowedRegexLength) {
            throw new IllegalArgumentException("The length of regex [" + this.value.length() + "] used in the Regexp Query request has exceeded the allowed maximum of [" + maxAllowedRegexLength + "]. This maximum can be set by changing the [" + IndexSettings.MAX_REGEX_LENGTH_SETTING.getKey() + "] index level setting.");
        }
        MultiTermQuery.RewriteMethod method = QueryParsers.parseRewriteMethod(this.rewrite, null, LoggingDeprecationHandler.INSTANCE);
        int matchFlagsValue = this.caseInsensitive ? 256 : 0;
        Query query = null;
        int sanitisedSyntaxFlag = this.syntaxFlagsValue & 0xFF;
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType != null) {
            query = fieldType.regexpQuery(this.value, sanitisedSyntaxFlag, matchFlagsValue, this.maxDeterminizedStates, method, context);
        }
        if (query == null) {
            RegexpQuery regexpQuery = new RegexpQuery(new Term(this.fieldName, BytesRefs.toBytesRef(this.value)), sanitisedSyntaxFlag, matchFlagsValue, this.maxDeterminizedStates);
            if (method != null) {
                regexpQuery.setRewriteMethod(method);
            }
            query = regexpQuery;
        }
        return query;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.value, this.syntaxFlagsValue, this.caseInsensitive, this.maxDeterminizedStates, this.rewrite);
    }

    @Override
    protected boolean doEquals(RegexpQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.value, other.value) && Objects.equals(this.syntaxFlagsValue, other.syntaxFlagsValue) && Objects.equals(this.caseInsensitive, other.caseInsensitive) && Objects.equals(this.maxDeterminizedStates, other.maxDeterminizedStates) && Objects.equals(this.rewrite, other.rewrite);
    }
}

