/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Assertions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MappingMetadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.compress.CompressedXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.regex.Regex;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.DeprecationHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.AbstractIndexComponent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.AnalysisRegistry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.CharFilterFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.IndexAnalyzers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.NamedAnalyzer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.ReloadableCustomAnalyzer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.TokenFilterFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.TokenizerFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ContentPath;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.DocumentMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.DocumentMapperForType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.DocumentMapperParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ObjectMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TypeFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.similarity.SimilarityService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.InvalidTypeNameException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.mapper.MapperRegistry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.ScriptService;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class MapperService
extends AbstractIndexComponent
implements Closeable {
    public static final String DEFAULT_MAPPING = "_default_";
    public static final String SINGLE_MAPPING_NAME = "_doc";
    public static final Setting<Long> INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_fields.limit", 50L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_objects.limit", 10000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.total_fields.limit", 1000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_DEPTH_LIMIT_SETTING = Setting.longSetting("index.mapping.depth.limit", 20L, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_FIELD_NAME_LENGTH_LIMIT_SETTING = Setting.longSetting("index.mapping.field_name_length.limit", Long.MAX_VALUE, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final boolean INDEX_MAPPER_DYNAMIC_DEFAULT = true;
    @Deprecated
    public static final Setting<Boolean> INDEX_MAPPER_DYNAMIC_SETTING = Setting.boolSetting("index.mapper.dynamic", true, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.Deprecated);
    @Deprecated
    public static final Set<String> META_FIELDS_BEFORE_7DOT8 = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("_id", "_ignored", "_index", "_routing", "_size", "_timestamp", "_ttl", "_type")));
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(MapperService.class);
    static final String DEFAULT_MAPPING_ERROR_MESSAGE = "[_default_] mappings are not allowed on new indices and should no longer be used. See [https://www.elastic.co/guide/en/elasticsearch/reference/current/breaking-changes-7.0.html#default-mapping-not-allowed] for more information.";
    private final IndexAnalyzers indexAnalyzers;
    private volatile String defaultMappingSource;
    private volatile DocumentMapper mapper;
    private volatile DocumentMapper defaultMapper;
    private final DocumentMapperParser documentParser;
    private final Version indexVersionCreated;
    private final MapperAnalyzerWrapper indexAnalyzer;
    private final MapperAnalyzerWrapper searchAnalyzer;
    private final MapperAnalyzerWrapper searchQuoteAnalyzer;
    private volatile Map<String, MappedFieldType> unmappedFieldTypes = Collections.emptyMap();
    final MapperRegistry mapperRegistry;
    private final BooleanSupplier idFieldDataEnabled;

    public MapperService(IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, NamedXContentRegistry xContentRegistry, SimilarityService similarityService, MapperRegistry mapperRegistry, Supplier<QueryShardContext> queryShardContextSupplier, BooleanSupplier idFieldDataEnabled, ScriptService scriptService) {
        super(indexSettings);
        this.indexVersionCreated = indexSettings.getIndexVersionCreated();
        this.indexAnalyzers = indexAnalyzers;
        this.documentParser = new DocumentMapperParser(indexSettings, this, xContentRegistry, similarityService, mapperRegistry, queryShardContextSupplier, scriptService);
        this.indexAnalyzer = new MapperAnalyzerWrapper(indexAnalyzers.getDefaultIndexAnalyzer(), MappedFieldType::indexAnalyzer);
        this.searchAnalyzer = new MapperAnalyzerWrapper(indexAnalyzers.getDefaultSearchAnalyzer(), p -> p.getTextSearchInfo().getSearchAnalyzer());
        this.searchQuoteAnalyzer = new MapperAnalyzerWrapper(indexAnalyzers.getDefaultSearchQuoteAnalyzer(), p -> p.getTextSearchInfo().getSearchQuoteAnalyzer());
        this.mapperRegistry = mapperRegistry;
        this.idFieldDataEnabled = idFieldDataEnabled;
        if (INDEX_MAPPER_DYNAMIC_SETTING.exists(indexSettings.getSettings()) && indexSettings.getIndexVersionCreated().onOrAfter(Version.V_7_0_0)) {
            throw new IllegalArgumentException("Setting " + INDEX_MAPPER_DYNAMIC_SETTING.getKey() + " was removed after version 6.0.0");
        }
        this.defaultMappingSource = "{\"_default_\":{}}";
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("default mapping source[{}]", (Object)this.defaultMappingSource);
        }
    }

    public boolean hasNested() {
        return this.mapper != null && this.mapper.hasNestedObjects();
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.indexAnalyzers;
    }

    public NamedAnalyzer getNamedAnalyzer(String analyzerName) {
        return this.indexAnalyzers.get(analyzerName);
    }

    public DocumentMapperParser documentMapperParser() {
        return this.documentParser;
    }

    public static Map<String, Object> parseMapping(NamedXContentRegistry xContentRegistry, String mappingSource) throws IOException {
        try (XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mappingSource);){
            Map<String, Object> map = parser.map();
            return map;
        }
    }

    public boolean updateMapping(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) throws IOException {
        Map<String, DocumentMapper> updatedEntries;
        assert (newIndexMetadata.getIndex().equals(this.index())) : "index mismatch: expected " + this.index() + " but was " + newIndexMetadata.getIndex();
        if (currentIndexMetadata != null && currentIndexMetadata.getMappingVersion() == newIndexMetadata.getMappingVersion()) {
            this.assertMappingVersion(currentIndexMetadata, newIndexMetadata, Collections.emptyMap());
            return false;
        }
        HashSet<String> existingMappers = new HashSet<String>();
        if (this.mapper != null) {
            existingMappers.add(this.mapper.type());
        }
        if (this.defaultMapper != null) {
            existingMappers.add(DEFAULT_MAPPING);
        }
        try {
            updatedEntries = this.internalMerge(newIndexMetadata, MergeReason.MAPPING_RECOVERY);
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("[{}] failed to apply mappings", (Object)this.index()), (Throwable)e);
            throw e;
        }
        boolean requireRefresh = false;
        this.assertMappingVersion(currentIndexMetadata, newIndexMetadata, updatedEntries);
        for (DocumentMapper documentMapper : updatedEntries.values()) {
            String op;
            MappingMetadata mappingMetadata;
            String mappingType = documentMapper.type();
            if (mappingType.equals(DEFAULT_MAPPING)) {
                mappingMetadata = newIndexMetadata.defaultMapping();
            } else {
                mappingMetadata = newIndexMetadata.mapping();
                assert (mappingType.equals(mappingMetadata.type()));
            }
            CompressedXContent incomingMappingSource = mappingMetadata.source();
            String string = op = existingMappers.contains(mappingType) ? "updated" : "added";
            if (this.logger.isDebugEnabled() && incomingMappingSource.compressed().length < 512) {
                this.logger.debug("[{}] {} mapping [{}], source [{}]", (Object)this.index(), (Object)op, (Object)mappingType, (Object)incomingMappingSource.string());
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] {} mapping [{}], source [{}]", (Object)this.index(), (Object)op, (Object)mappingType, (Object)incomingMappingSource.string());
            } else {
                this.logger.debug("[{}] {} mapping [{}] (source suppressed due to length, use TRACE level if needed)", (Object)this.index(), (Object)op, (Object)mappingType);
            }
            if (this.documentMapper(mappingType).mappingSource().equals(incomingMappingSource)) continue;
            this.logger.debug("[{}] parsed mapping [{}], and got different sources\noriginal:\n{}\nparsed:\n{}", (Object)this.index(), (Object)mappingType, (Object)incomingMappingSource, (Object)this.documentMapper(mappingType).mappingSource());
            requireRefresh = true;
        }
        return requireRefresh;
    }

    private void assertMappingVersion(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata, Map<String, DocumentMapper> updatedEntries) throws IOException {
        if (Assertions.ENABLED && currentIndexMetadata != null && currentIndexMetadata.getCreationVersion().onOrAfter(Version.V_6_5_0)) {
            if (currentIndexMetadata.getMappingVersion() == newIndexMetadata.getMappingVersion()) {
                MappingMetadata mapping;
                assert (updatedEntries.isEmpty()) : updatedEntries;
                MappingMetadata defaultMapping = newIndexMetadata.defaultMapping();
                if (defaultMapping != null) {
                    CompressedXContent currentSource = currentIndexMetadata.defaultMapping().source();
                    CompressedXContent newSource = defaultMapping.source();
                    assert (currentSource.equals(newSource)) : "expected current mapping [" + currentSource + "] for type [" + defaultMapping.type() + "] to be the same as new mapping [" + newSource + "]";
                }
                if ((mapping = newIndexMetadata.mapping()) != null) {
                    CompressedXContent currentSource = currentIndexMetadata.mapping().source();
                    CompressedXContent newSource = mapping.source();
                    assert (currentSource.equals(newSource)) : "expected current mapping [" + currentSource + "] for type [" + mapping.type() + "] to be the same as new mapping [" + newSource + "]";
                    CompressedXContent mapperSource = new CompressedXContent(Strings.toString(this.mapper));
                    assert (currentSource.equals(mapperSource)) : "expected current mapping [" + currentSource + "] for type [" + mapping.type() + "] to be the same as new mapping [" + mapperSource + "]";
                }
            } else {
                long currentMappingVersion = currentIndexMetadata.getMappingVersion();
                long newMappingVersion = newIndexMetadata.getMappingVersion();
                assert (currentMappingVersion < newMappingVersion) : "expected current mapping version [" + currentMappingVersion + "] to be less than new mapping version [" + newMappingVersion + "]";
                assert (!updatedEntries.isEmpty());
                for (DocumentMapper documentMapper : updatedEntries.values()) {
                    MappingMetadata currentMapping;
                    if (documentMapper.type().equals(DEFAULT_MAPPING)) {
                        currentMapping = currentIndexMetadata.defaultMapping();
                    } else {
                        currentMapping = currentIndexMetadata.mapping();
                        assert (currentMapping == null || documentMapper.type().equals(currentMapping.type()));
                    }
                    if (currentMapping == null) continue;
                    CompressedXContent currentSource = currentMapping.source();
                    CompressedXContent newSource = documentMapper.mappingSource();
                    assert (!currentSource.equals(newSource)) : "expected current mapping [" + currentSource + "] for type [" + documentMapper.type() + "] to be different than new mapping";
                }
            }
        }
    }

    public void merge(Map<String, Map<String, Object>> mappings, MergeReason reason) {
        LinkedHashMap<String, CompressedXContent> mappingSourcesCompressed = new LinkedHashMap<String, CompressedXContent>(mappings.size());
        for (Map.Entry<String, Map<String, Object>> entry : mappings.entrySet()) {
            try {
                mappingSourcesCompressed.put(entry.getKey(), new CompressedXContent(Strings.toString(XContentFactory.jsonBuilder().map(entry.getValue()))));
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
            }
        }
        this.internalMerge(mappingSourcesCompressed, reason);
    }

    public void merge(String type, Map<String, Object> mappings, MergeReason reason) throws IOException {
        CompressedXContent content = new CompressedXContent(Strings.toString(XContentFactory.jsonBuilder().map(mappings)));
        this.internalMerge(Collections.singletonMap(type, content), reason);
    }

    public void merge(IndexMetadata indexMetadata, MergeReason reason) {
        this.internalMerge(indexMetadata, reason);
    }

    public DocumentMapper merge(String type, CompressedXContent mappingSource, MergeReason reason) {
        return this.internalMerge(Collections.singletonMap(type, mappingSource), reason).get(type);
    }

    private synchronized Map<String, DocumentMapper> internalMerge(IndexMetadata indexMetadata, MergeReason reason) {
        assert (reason != MergeReason.MAPPING_UPDATE_PREFLIGHT);
        LinkedHashMap<String, CompressedXContent> map = new LinkedHashMap<String, CompressedXContent>();
        for (ObjectCursor<MappingMetadata> objectCursor : indexMetadata.getMappings().values()) {
            MappingMetadata mappingMetadata = (MappingMetadata)objectCursor.value;
            map.put(mappingMetadata.type(), mappingMetadata.source());
        }
        return this.internalMerge(map, reason);
    }

    private synchronized Map<String, DocumentMapper> internalMerge(Map<String, CompressedXContent> mappings, MergeReason reason) {
        DocumentMapper defaultMapper = null;
        String defaultMappingSource = null;
        if (mappings.containsKey(DEFAULT_MAPPING)) {
            try {
                defaultMapper = this.documentParser.parse(DEFAULT_MAPPING, mappings.get(DEFAULT_MAPPING));
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, DEFAULT_MAPPING, e.getMessage());
            }
            defaultMappingSource = mappings.get(DEFAULT_MAPPING).string();
        }
        String defaultMappingSourceOrLastStored = defaultMappingSource != null ? defaultMappingSource : this.defaultMappingSource;
        DocumentMapper documentMapper = null;
        for (Map.Entry<String, CompressedXContent> entry : mappings.entrySet()) {
            String type = entry.getKey();
            if (type.equals(DEFAULT_MAPPING)) continue;
            if (documentMapper != null) {
                throw new IllegalArgumentException("Cannot put multiple mappings: " + mappings.keySet());
            }
            boolean applyDefault = reason != MergeReason.MAPPING_RECOVERY && this.mapper == null;
            try {
                documentMapper = this.documentParser.parse(type, entry.getValue(), applyDefault ? defaultMappingSourceOrLastStored : null);
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
            }
        }
        return this.internalMerge(defaultMapper, defaultMappingSource, documentMapper, reason);
    }

    static void validateTypeName(String type) {
        if (type.length() == 0) {
            throw new InvalidTypeNameException("mapping type name is empty");
        }
        if (type.length() > 255) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] is too long; limit is length 255 but was [" + type.length() + "]");
        }
        if (type.charAt(0) == '_' && !SINGLE_MAPPING_NAME.equals(type)) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] can't start with '_' unless it is called [" + SINGLE_MAPPING_NAME + "]");
        }
        if (type.contains("#")) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] should not include '#' in it");
        }
        if (type.contains(",")) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] should not include ',' in it");
        }
        if (type.charAt(0) == '.') {
            throw new IllegalArgumentException("mapping type name [" + type + "] must not start with a '.'");
        }
    }

    private synchronized Map<String, DocumentMapper> internalMerge(@Nullable DocumentMapper defaultMapper, @Nullable String defaultMappingSource, DocumentMapper mapper, MergeReason reason) {
        LinkedHashMap<String, DocumentMapper> results = new LinkedHashMap(2);
        if (defaultMapper != null) {
            if (this.indexSettings.getIndexVersionCreated().onOrAfter(Version.V_7_0_0)) {
                throw new IllegalArgumentException(DEFAULT_MAPPING_ERROR_MESSAGE);
            }
            if (reason == MergeReason.MAPPING_UPDATE) {
                deprecationLogger.deprecate("default_mapping_not_allowed", DEFAULT_MAPPING_ERROR_MESSAGE, new Object[0]);
            }
            assert (defaultMapper.type().equals(DEFAULT_MAPPING));
            results.put(DEFAULT_MAPPING, defaultMapper);
        }
        DocumentMapper newMapper = null;
        if (mapper != null) {
            MapperService.validateTypeName(mapper.type());
            DocumentMapper oldMapper = this.mapper;
            newMapper = oldMapper != null ? oldMapper.merge(mapper.mapping(), reason) : mapper;
            newMapper.root().fixRedundantIncludes();
            newMapper.validate(this.indexSettings, reason != MergeReason.MAPPING_RECOVERY);
            results.put(newMapper.type(), newMapper);
        }
        results = Collections.unmodifiableMap(results);
        if (reason == MergeReason.MAPPING_UPDATE_PREFLIGHT) {
            return results;
        }
        if (defaultMappingSource != null) {
            this.defaultMappingSource = defaultMappingSource;
            this.defaultMapper = defaultMapper;
        }
        if (newMapper != null) {
            this.mapper = newMapper;
        }
        assert (results.values().stream().allMatch(this::assertSerialization));
        return results;
    }

    private boolean assertSerialization(DocumentMapper mapper) {
        CompressedXContent mappingSource = mapper.mappingSource();
        DocumentMapper newMapper = this.parse(mapper.type(), mappingSource, false);
        if (!newMapper.mappingSource().equals(mappingSource)) {
            throw new IllegalStateException("DocumentMapper serialization result is different from source. \n--> Source [" + mappingSource + "]\n--> Result [" + newMapper.mappingSource() + "]");
        }
        return true;
    }

    public DocumentMapper parse(String mappingType, CompressedXContent mappingSource, boolean applyDefault) throws MapperParsingException {
        return this.documentParser.parse(mappingType, mappingSource, applyDefault ? this.defaultMappingSource : null);
    }

    public DocumentMapper documentMapper() {
        return this.mapper;
    }

    public DocumentMapper documentMapper(String type) {
        if (this.mapper != null && type.equals(this.mapper.type())) {
            return this.mapper;
        }
        if (DEFAULT_MAPPING.equals(type)) {
            return this.defaultMapper;
        }
        return null;
    }

    public static boolean isMappingSourceTyped(String type, Map<String, Object> mapping) {
        return mapping.size() == 1 && mapping.keySet().iterator().next().equals(type);
    }

    public static boolean isMappingSourceTyped(String type, CompressedXContent mappingSource) {
        Map<String, Object> root = XContentHelper.convertToMap(mappingSource.compressedReference(), true, XContentType.JSON).v2();
        return MapperService.isMappingSourceTyped(type, root);
    }

    public String getTypeForUpdate(String type, CompressedXContent mappingSource) {
        return !MapperService.isMappingSourceTyped(type, mappingSource) ? this.resolveDocumentType(type) : type;
    }

    public String resolveDocumentType(String type) {
        if (SINGLE_MAPPING_NAME.equals(type) && this.mapper != null) {
            return this.mapper.type();
        }
        return type;
    }

    public DocumentMapperForType documentMapperWithAutoCreate(String type) {
        DocumentMapper mapper = this.documentMapper(type);
        if (mapper != null) {
            return new DocumentMapperForType(mapper, null);
        }
        mapper = this.parse(type, null, true);
        return new DocumentMapperForType(mapper, mapper.mapping());
    }

    public MappedFieldType fieldType(String fullName) {
        if (fullName.equals("_type")) {
            String type = this.mapper == null ? null : this.mapper.type();
            return new TypeFieldMapper.TypeFieldType(type);
        }
        return this.mapper == null ? null : this.mapper.fieldTypes().get(fullName);
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return Collections.singleton(pattern);
        }
        return this.mapper == null ? Collections.emptySet() : this.mapper.fieldTypes().simpleMatchToFullName(pattern);
    }

    public Set<String> sourcePath(String fullName) {
        return this.mapper == null ? Collections.emptySet() : this.mapper.fieldTypes().sourcePaths(fullName);
    }

    public Iterable<MappedFieldType> fieldTypes() {
        return this.mapper == null ? Collections.emptySet() : this.mapper.fieldTypes();
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.mapper == null ? null : this.mapper.objectMappers().get(name);
    }

    public MappedFieldType unmappedFieldType(String type) {
        MappedFieldType fieldType;
        if (type.equals("string")) {
            deprecationLogger.deprecate("unmapped_type_string", "[unmapped_type:string] should be replaced with [unmapped_type:keyword]", new Object[0]);
            type = "keyword";
        }
        if ((fieldType = this.unmappedFieldTypes.get(type)) == null) {
            Mapper.TypeParser.ParserContext parserContext = this.documentMapperParser().parserContext();
            Mapper.TypeParser typeParser = parserContext.typeParser(type);
            if (typeParser == null) {
                throw new IllegalArgumentException("No mapper found for type [" + type + "]");
            }
            Mapper.Builder<?> builder = typeParser.parse("__anonymous_" + type, Collections.emptyMap(), parserContext);
            Mapper.BuilderContext builderContext = new Mapper.BuilderContext(this.indexSettings.getSettings(), new ContentPath(1));
            fieldType = ((FieldMapper)builder.build(builderContext)).fieldType();
            HashMap<String, MappedFieldType> newUnmappedFieldTypes = new HashMap<String, MappedFieldType>(this.unmappedFieldTypes);
            newUnmappedFieldTypes.put(type, fieldType);
            this.unmappedFieldTypes = Collections.unmodifiableMap(newUnmappedFieldTypes);
        }
        return fieldType;
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    public boolean isIdFieldDataEnabled() {
        return this.idFieldDataEnabled.getAsBoolean();
    }

    @Override
    public void close() throws IOException {
        this.indexAnalyzers.close();
    }

    public boolean isMetadataField(String field) {
        return this.mapperRegistry.isMetadataField(this.indexVersionCreated, field);
    }

    public synchronized List<String> reloadSearchAnalyzers(AnalysisRegistry registry) throws IOException {
        this.logger.info("reloading search analyzers");
        Map<String, TokenizerFactory> tokenizerFactories = registry.buildTokenizerFactories(this.indexSettings);
        Map<String, CharFilterFactory> charFilterFactories = registry.buildCharFilterFactories(this.indexSettings);
        Map<String, TokenFilterFactory> tokenFilterFactories = registry.buildTokenFilterFactories(this.indexSettings);
        Map<String, Settings> settings = this.indexSettings.getSettings().getGroups("index.analysis.analyzer");
        ArrayList<String> reloadedAnalyzers = new ArrayList<String>();
        for (NamedAnalyzer namedAnalyzer : this.indexAnalyzers.getAnalyzers().values()) {
            if (!(namedAnalyzer.analyzer() instanceof ReloadableCustomAnalyzer)) continue;
            ReloadableCustomAnalyzer analyzer = (ReloadableCustomAnalyzer)namedAnalyzer.analyzer();
            String analyzerName = namedAnalyzer.name();
            Settings analyzerSettings = settings.get(analyzerName);
            analyzer.reload(analyzerName, analyzerSettings, tokenizerFactories, charFilterFactories, tokenFilterFactories);
            reloadedAnalyzers.add(analyzerName);
        }
        return reloadedAnalyzers;
    }

    final class MapperAnalyzerWrapper
    extends DelegatingAnalyzerWrapper {
        private final Analyzer defaultAnalyzer;
        private final Function<MappedFieldType, Analyzer> extractAnalyzer;

        MapperAnalyzerWrapper(Analyzer defaultAnalyzer, Function<MappedFieldType, Analyzer> extractAnalyzer) {
            super(Analyzer.PER_FIELD_REUSE_STRATEGY);
            this.defaultAnalyzer = defaultAnalyzer;
            this.extractAnalyzer = extractAnalyzer;
        }

        @Override
        protected Analyzer getWrappedAnalyzer(String fieldName) {
            Analyzer analyzer;
            MappedFieldType fieldType = MapperService.this.fieldType(fieldName);
            if (fieldType != null && (analyzer = this.extractAnalyzer.apply(fieldType)) != null) {
                return analyzer;
            }
            return this.defaultAnalyzer;
        }
    }

    public static enum MergeReason {
        MAPPING_UPDATE_PREFLIGHT,
        MAPPING_UPDATE,
        INDEX_TEMPLATE,
        MAPPING_RECOVERY;

    }
}

