/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.Field;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.StoredField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexableFieldType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TermRangeQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Booleans;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParametrizedFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.SourceValueFetcher;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TermBasedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TextSearchInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ValueFetcher;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.lookup.SearchLookup;

public class BooleanFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "boolean";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final Boolean nullValue;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;

    private static BooleanFieldMapper toType(FieldMapper in) {
        return (BooleanFieldMapper)in;
    }

    protected BooleanFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.nullValue = (Boolean)builder.nullValue.getValue();
        this.stored = (Boolean)builder.stored.getValue();
        this.indexed = (Boolean)builder.indexed.getValue();
        this.hasDocValues = (Boolean)builder.docValues.getValue();
    }

    @Override
    public BooleanFieldType fieldType() {
        return (BooleanFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        if (!(this.indexed || this.stored || this.hasDocValues)) {
            return;
        }
        Boolean value = context.parseExternalValue(Boolean.class);
        if (value == null) {
            XContentParser.Token token = context.parser().currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                if (this.nullValue != null) {
                    value = this.nullValue;
                }
            } else {
                value = context.parser().booleanValue();
            }
        }
        if (value == null) {
            return;
        }
        if (this.indexed) {
            context.doc().add(new Field(this.fieldType().name(), value != false ? "T" : "F", (IndexableFieldType)Defaults.FIELD_TYPE));
        }
        if (this.stored) {
            context.doc().add(new StoredField(this.fieldType().name(), value != false ? "T" : "F"));
        }
        if (this.hasDocValues) {
            context.doc().add(new SortedNumericDocValuesField(this.fieldType().name(), value != false ? 1L : 0L));
        } else {
            this.createFieldNamesField(context);
        }
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> docValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> BooleanFieldMapper.access$400(BooleanFieldMapper.toType(m)), true);
        private final ParametrizedFieldMapper.Parameter<Boolean> indexed = ParametrizedFieldMapper.Parameter.indexParam(m -> BooleanFieldMapper.access$300(BooleanFieldMapper.toType(m)), true);
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m -> BooleanFieldMapper.access$200(BooleanFieldMapper.toType(m)), false);
        private final ParametrizedFieldMapper.Parameter<Boolean> nullValue = new ParametrizedFieldMapper.Parameter<Boolean>("null_value", false, () -> null, (n, c, o) -> o == null ? null : Boolean.valueOf(XContentMapValues.nodeBooleanValue(o)), m -> BooleanFieldMapper.access$100(BooleanFieldMapper.toType(m))).acceptsNull();
        private final ParametrizedFieldMapper.Parameter<Float> boost = ParametrizedFieldMapper.Parameter.boostParam();
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.meta, this.boost, this.docValues, this.indexed, this.nullValue, this.stored);
        }

        @Override
        public BooleanFieldMapper build(Mapper.BuilderContext context) {
            BooleanFieldType ft = new BooleanFieldType(this.buildFullName(context), (boolean)this.indexed.getValue(), (boolean)this.stored.getValue(), (boolean)this.docValues.getValue(), this.nullValue.getValue(), this.meta.getValue());
            ft.setBoost(this.boost.getValue().floatValue());
            return new BooleanFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    public static final class BooleanFieldType
    extends TermBasedFieldType {
        private final Boolean nullValue;

        public BooleanFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, Boolean nullValue, Map<String, String> meta) {
            super(name, isSearchable, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.nullValue = nullValue;
        }

        public BooleanFieldType(String name) {
            this(name, true, false, true, false, Collections.emptyMap());
        }

        public BooleanFieldType(String name, boolean searchable) {
            this(name, searchable, false, true, false, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return BooleanFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), mapperService, this.nullValue){

                @Override
                protected Boolean parseSourceValue(Object value) {
                    if (value instanceof Boolean) {
                        return (Boolean)value;
                    }
                    String textValue = value.toString();
                    return Booleans.parseBoolean(textValue.toCharArray(), 0, textValue.length(), false);
                }
            };
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            if (value == null) {
                return Values.FALSE;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? Values.TRUE : Values.FALSE;
            }
            String sValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            switch (sValue) {
                case "true": {
                    return Values.TRUE;
                }
                case "false": {
                    return Values.FALSE;
                }
            }
            throw new IllegalArgumentException("Can't parse boolean value [" + sValue + "], expected [true] or [false]");
        }

        @Override
        public Boolean valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            switch (value.toString()) {
                case "F": {
                    return false;
                }
                case "T": {
                    return true;
                }
            }
            throw new IllegalArgumentException("Expected [T] or [F] but got [" + value + "]");
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.BOOLEAN);
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
            }
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            return DocValueFormat.BOOLEAN;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexed();
            return new TermRangeQuery(this.name(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.freeze();
        }
    }

    public static class Values {
        public static final BytesRef TRUE = new BytesRef("T");
        public static final BytesRef FALSE = new BytesRef("F");
    }
}

