/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.spi;

import java.util.Objects;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Binder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.ConfigurationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.TypeLiteral;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.spi.Element;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.spi.ElementVisitor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.spi.InjectionPoint;

public final class InjectionRequest<T>
implements Element {
    private final Object source;
    private final TypeLiteral<T> type;
    private final T instance;

    public InjectionRequest(Object source, TypeLiteral<T> type, T instance) {
        this.source = Objects.requireNonNull(source, "source");
        this.type = Objects.requireNonNull(type, "type");
        this.instance = Objects.requireNonNull(instance, "instance");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public T getInstance() {
        return this.instance;
    }

    public TypeLiteral<T> getType() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() throws ConfigurationException {
        return InjectionPoint.forInstanceMethodsAndFields(this.instance.getClass());
    }

    public <R> R acceptVisitor(ElementVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).requestInjection(this.type, this.instance);
    }
}

