/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.datafeed;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class DatafeedTimingStats
implements ToXContentObject {
    public static final ParseField JOB_ID = new ParseField("job_id", new String[0]);
    public static final ParseField SEARCH_COUNT = new ParseField("search_count", new String[0]);
    public static final ParseField BUCKET_COUNT = new ParseField("bucket_count", new String[0]);
    public static final ParseField TOTAL_SEARCH_TIME_MS = new ParseField("total_search_time_ms", new String[0]);
    public static final ParseField AVG_SEARCH_TIME_PER_BUCKET_MS = new ParseField("average_search_time_per_bucket_ms", new String[0]);
    public static final ParseField EXPONENTIAL_AVG_SEARCH_TIME_PER_HOUR_MS = new ParseField("exponential_average_search_time_per_hour_ms", new String[0]);
    public static final ParseField TYPE = new ParseField("datafeed_timing_stats", new String[0]);
    public static final ConstructingObjectParser<DatafeedTimingStats, Void> PARSER = DatafeedTimingStats.createParser();
    private final String jobId;
    private long searchCount;
    private long bucketCount;
    private double totalSearchTimeMs;
    private Double avgSearchTimePerBucketMs;
    private Double exponentialAvgSearchTimePerHourMs;

    private static ConstructingObjectParser<DatafeedTimingStats, Void> createParser() {
        ConstructingObjectParser<DatafeedTimingStats, Void> parser = new ConstructingObjectParser<DatafeedTimingStats, Void>("datafeed_timing_stats", true, args -> {
            String jobId = (String)args[0];
            Long searchCount = (Long)args[1];
            Long bucketCount = (Long)args[2];
            Double totalSearchTimeMs = (Double)args[3];
            Double avgSearchTimePerBucketMs = (Double)args[4];
            Double exponentialAvgSearchTimePerHourMs = (Double)args[5];
            return new DatafeedTimingStats(jobId, DatafeedTimingStats.getOrDefault(searchCount, 0L), DatafeedTimingStats.getOrDefault(bucketCount, 0L), DatafeedTimingStats.getOrDefault(totalSearchTimeMs, 0.0), avgSearchTimePerBucketMs, exponentialAvgSearchTimePerHourMs);
        });
        parser.declareString(ConstructingObjectParser.constructorArg(), JOB_ID);
        parser.declareLong(ConstructingObjectParser.optionalConstructorArg(), SEARCH_COUNT);
        parser.declareLong(ConstructingObjectParser.optionalConstructorArg(), BUCKET_COUNT);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), TOTAL_SEARCH_TIME_MS);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), AVG_SEARCH_TIME_PER_BUCKET_MS);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), EXPONENTIAL_AVG_SEARCH_TIME_PER_HOUR_MS);
        return parser;
    }

    public DatafeedTimingStats(String jobId, long searchCount, long bucketCount, double totalSearchTimeMs, @Nullable Double avgSearchTimePerBucketMs, @Nullable Double exponentialAvgSearchTimePerHourMs) {
        this.jobId = Objects.requireNonNull(jobId);
        this.searchCount = searchCount;
        this.bucketCount = bucketCount;
        this.totalSearchTimeMs = totalSearchTimeMs;
        this.avgSearchTimePerBucketMs = avgSearchTimePerBucketMs;
        this.exponentialAvgSearchTimePerHourMs = exponentialAvgSearchTimePerHourMs;
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getSearchCount() {
        return this.searchCount;
    }

    public long getBucketCount() {
        return this.bucketCount;
    }

    public double getTotalSearchTimeMs() {
        return this.totalSearchTimeMs;
    }

    public Double getAvgSearchTimePerBucketMs() {
        return this.avgSearchTimePerBucketMs;
    }

    public Double getExponentialAvgSearchTimePerHourMs() {
        return this.exponentialAvgSearchTimePerHourMs;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(JOB_ID.getPreferredName(), this.jobId);
        builder.field(SEARCH_COUNT.getPreferredName(), this.searchCount);
        builder.field(BUCKET_COUNT.getPreferredName(), this.bucketCount);
        builder.field(TOTAL_SEARCH_TIME_MS.getPreferredName(), this.totalSearchTimeMs);
        if (this.avgSearchTimePerBucketMs != null) {
            builder.field(AVG_SEARCH_TIME_PER_BUCKET_MS.getPreferredName(), this.avgSearchTimePerBucketMs);
        }
        if (this.exponentialAvgSearchTimePerHourMs != null) {
            builder.field(EXPONENTIAL_AVG_SEARCH_TIME_PER_HOUR_MS.getPreferredName(), this.exponentialAvgSearchTimePerHourMs);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DatafeedTimingStats other = (DatafeedTimingStats)obj;
        return Objects.equals(this.jobId, other.jobId) && this.searchCount == other.searchCount && this.bucketCount == other.bucketCount && this.totalSearchTimeMs == other.totalSearchTimeMs && Objects.equals(this.avgSearchTimePerBucketMs, other.avgSearchTimePerBucketMs) && Objects.equals(this.exponentialAvgSearchTimePerHourMs, other.exponentialAvgSearchTimePerHourMs);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.searchCount, this.bucketCount, this.totalSearchTimeMs, this.avgSearchTimePerBucketMs, this.exponentialAvgSearchTimePerHourMs);
    }

    public String toString() {
        return Strings.toString(this);
    }

    private static <T> T getOrDefault(@Nullable T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }
}

