/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.license;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParseException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;

public class StartBasicResponse {
    private static final ConstructingObjectParser<StartBasicResponse, Void> PARSER = new ConstructingObjectParser<StartBasicResponse, Void>("start_basic_response", true, (a, v) -> {
        boolean basicWasStarted = (Boolean)a[0];
        String errorMessage = (String)a[1];
        if (basicWasStarted) {
            return new StartBasicResponse(Status.GENERATED_BASIC);
        }
        Status status = Status.fromErrorMessage(errorMessage);
        Tuple acknowledgements = (Tuple)a[2];
        return new StartBasicResponse(status, (Map)acknowledgements.v2(), (String)acknowledgements.v1());
    });
    private Map<String, String[]> acknowledgeMessages;
    private String acknowledgeMessage;
    private Status status;

    private StartBasicResponse(Status status) {
        this(status, Collections.emptyMap(), null);
    }

    private StartBasicResponse(Status status, Map<String, String[]> acknowledgeMessages, String acknowledgeMessage) {
        this.status = status;
        this.acknowledgeMessages = acknowledgeMessages;
        this.acknowledgeMessage = acknowledgeMessage;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isAcknowledged() {
        return this.status != Status.NEED_ACKNOWLEDGEMENT;
    }

    public boolean isBasicStarted() {
        return this.status.isBasicStarted;
    }

    public String getErrorMessage() {
        return this.status.errorMessage;
    }

    public String getAcknowledgeMessage() {
        return this.acknowledgeMessage;
    }

    public Map<String, String[]> getAcknowledgeMessages() {
        return this.acknowledgeMessages;
    }

    public static StartBasicResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("basic_was_started", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("error_message", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, v) -> {
            XContentParser.Token token;
            HashMap<String, String[]> acknowledgeMessages = new HashMap<String, String[]>();
            String message = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (currentFieldName == null) {
                    throw new XContentParseException(parser.getTokenLocation(), "expected message header or acknowledgement");
                }
                if (new ParseField("message", new String[0]).getPreferredName().equals(currentFieldName)) {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_STRING, token, parser);
                    message = parser.text();
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY) {
                    throw new XContentParseException(parser.getTokenLocation(), "unexpected acknowledgement type");
                }
                ArrayList<String> acknowledgeMessagesList = new ArrayList<String>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_STRING, token, parser);
                    acknowledgeMessagesList.add(parser.text());
                }
                acknowledgeMessages.put(currentFieldName, acknowledgeMessagesList.toArray(new String[0]));
            }
            return new Tuple(message, acknowledgeMessages);
        }, new ParseField("acknowledge", new String[0]));
    }

    public static enum Status {
        GENERATED_BASIC(true, null),
        ALREADY_USING_BASIC(false, "Operation failed: Current license is basic."),
        NEED_ACKNOWLEDGEMENT(false, "Operation failed: Needs acknowledgement.");

        private final boolean isBasicStarted;
        private final String errorMessage;

        private Status(boolean isBasicStarted, String errorMessage) {
            this.isBasicStarted = isBasicStarted;
            this.errorMessage = errorMessage;
        }

        static Status fromErrorMessage(String errorMessage) {
            Status[] values;
            for (Status status : values = Status.values()) {
                if (!Objects.equals(status.errorMessage, errorMessage)) continue;
                return status;
            }
            throw new IllegalArgumentException("No status for error message ['" + errorMessage + "']");
        }
    }
}

