/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.indices;

import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.TimedRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.ArrayUtils;

public class GetIndexRequest
extends TimedRequest {
    static final Feature[] DEFAULT_FEATURES = new Feature[]{Feature.ALIASES, Feature.MAPPINGS, Feature.SETTINGS};
    private Feature[] features = DEFAULT_FEATURES;
    private boolean humanReadable = false;
    private transient boolean includeDefaults = false;
    private final String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, true);
    private boolean local = false;

    public GetIndexRequest(String ... indices) {
        this.indices = indices;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public GetIndexRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public final GetIndexRequest local(boolean local) {
        this.local = local;
        return this;
    }

    public final boolean local() {
        return this.local;
    }

    public GetIndexRequest features(Feature ... features) {
        if (features == null) {
            throw new IllegalArgumentException("features cannot be null");
        }
        this.features = features;
        return this;
    }

    public GetIndexRequest addFeatures(Feature ... features) {
        if (this.features == DEFAULT_FEATURES) {
            return this.features(features);
        }
        return this.features(ArrayUtils.concat(this.features(), features, Feature.class));
    }

    public Feature[] features() {
        return this.features;
    }

    public GetIndexRequest humanReadable(boolean humanReadable) {
        this.humanReadable = humanReadable;
        return this;
    }

    public boolean humanReadable() {
        return this.humanReadable;
    }

    public GetIndexRequest includeDefaults(boolean includeDefaults) {
        this.includeDefaults = includeDefaults;
        return this;
    }

    public boolean includeDefaults() {
        return this.includeDefaults;
    }

    public static enum Feature {
        ALIASES,
        MAPPINGS,
        SETTINGS;

    }
}

