/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.ArraySearchPhaseResults;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.DfsQueryPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.FetchSearchPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.QueryPhaseResultConsumer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchPhaseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchPhaseController;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchPhaseResults;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchProgressListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchShardIterator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchTask;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchTransportService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.TransportSearchAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchPhaseResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchShardTarget;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.dfs.AggregatedDfs;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.dfs.DfsSearchResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.AliasFilter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.Transport;
import org.apache.logging.log4j.Logger;

final class SearchDfsQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<DfsSearchResult> {
    private final SearchPhaseController searchPhaseController;
    private final QueryPhaseResultConsumer queryPhaseResultConsumer;

    SearchDfsQueryThenFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, SearchPhaseController searchPhaseController, Executor executor, QueryPhaseResultConsumer queryPhaseResultConsumer, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, ClusterState clusterState, SearchTask task, SearchResponse.Clusters clusters) {
        super("dfs", logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, indexRoutings, executor, request, listener, shardsIts, timeProvider, clusterState, task, new ArraySearchPhaseResults(shardsIts.size()), request.getMaxConcurrentShardRequests(), clusters);
        this.queryPhaseResultConsumer = queryPhaseResultConsumer;
        this.searchPhaseController = searchPhaseController;
        SearchProgressListener progressListener = task.getProgressListener();
        SearchSourceBuilder sourceBuilder = request.source();
        progressListener.notifyListShards(SearchProgressListener.buildSearchShards(this.shardsIts), SearchProgressListener.buildSearchShards(this.toSkipShardsIts), clusters, sourceBuilder == null || sourceBuilder.size() != 0);
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, SearchShardTarget shard, SearchActionListener<DfsSearchResult> listener) {
        this.getSearchTransport().sendExecuteDfs(this.getConnection(shard.getClusterAlias(), shard.getNodeId()), this.buildShardSearchRequest(shardIt), this.getTask(), listener);
    }

    @Override
    protected SearchPhase getNextPhase(SearchPhaseResults<DfsSearchResult> results, SearchPhaseContext context) {
        List<DfsSearchResult> dfsSearchResults = results.getAtomicArray().asList();
        AggregatedDfs aggregatedDfs = this.searchPhaseController.aggregateDfs(dfsSearchResults);
        return new DfsQueryPhase(dfsSearchResults, aggregatedDfs, this.queryPhaseResultConsumer, queryResults -> new FetchSearchPhase((SearchPhaseResults<SearchPhaseResult>)queryResults, this.searchPhaseController, aggregatedDfs, context), context);
    }
}

