/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public final class IndexFeatureStats
implements ToXContent,
Writeable {
    final String name;
    int count;
    int indexCount;

    IndexFeatureStats(String name) {
        this.name = Objects.requireNonNull(name);
    }

    IndexFeatureStats(StreamInput in) throws IOException {
        this.name = in.readString();
        this.count = in.readVInt();
        this.indexCount = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVInt(this.count);
        out.writeVInt(this.indexCount);
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.count;
    }

    public int getIndexCount() {
        return this.indexCount;
    }

    public boolean equals(Object other) {
        if (!(other instanceof IndexFeatureStats)) {
            return false;
        }
        IndexFeatureStats that = (IndexFeatureStats)other;
        return this.name.equals(that.name) && this.count == that.count && this.indexCount == that.indexCount;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.count, this.indexCount);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field("count", this.count);
        builder.field("index_count", this.indexCount);
        builder.endObject();
        return builder;
    }
}

