/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public final class SameThreadExecutorService
extends AbstractExecutorService {
    private volatile boolean shutdown;

    @Override
    public void execute(Runnable command) {
        this.checkShutdown();
        command.run();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return true;
    }

    private void checkShutdown() {
        if (this.shutdown) {
            throw new RejectedExecutionException("Executor is shut down.");
        }
    }
}

