/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.document;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.QueryVisitor;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreMode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.BitsProducer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.document.CompletionWeight;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.automaton.Automata;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.automaton.Automaton;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.automaton.RegExp;

public class RegexCompletionQuery
extends CompletionQuery {
    private final int flags;
    private final int maxDeterminizedStates;

    public RegexCompletionQuery(Term term) {
        this(term, null);
    }

    public RegexCompletionQuery(Term term, BitsProducer filter) {
        this(term, 255, 10000, filter);
    }

    public RegexCompletionQuery(Term term, int flags, int maxDeterminizedStates) {
        this(term, flags, maxDeterminizedStates, null);
    }

    public RegexCompletionQuery(Term term, int flags, int maxDeterminizedStates, BitsProducer filter) {
        super(term, filter);
        this.flags = flags;
        this.maxDeterminizedStates = maxDeterminizedStates;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        Automaton automaton = this.getTerm().text().isEmpty() ? Automata.makeEmpty() : new RegExp(this.getTerm().text(), this.flags).toAutomaton(this.maxDeterminizedStates);
        return new CompletionWeight(this, automaton);
    }

    public int getFlags() {
        return this.flags;
    }

    public int getMaxDeterminizedStates() {
        return this.maxDeterminizedStates;
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }
}

