/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.PhraseQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.QueryVisitor;

public class NGramPhraseQuery
extends Query {
    private final int n;
    private final PhraseQuery phraseQuery;

    public NGramPhraseQuery(int n, PhraseQuery query) {
        this.n = n;
        this.phraseQuery = Objects.requireNonNull(query);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        boolean isOptimizable;
        Term[] terms = this.phraseQuery.getTerms();
        int[] positions = this.phraseQuery.getPositions();
        boolean bl = isOptimizable = this.phraseQuery.getSlop() == 0 && this.n >= 2 && terms.length >= 3;
        if (isOptimizable) {
            for (int i = 1; i < positions.length; ++i) {
                if (positions[i] == positions[i - 1] + 1) continue;
                isOptimizable = false;
                break;
            }
        }
        if (!isOptimizable) {
            return this.phraseQuery.rewrite(reader);
        }
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        for (int i = 0; i < terms.length; ++i) {
            if (i % this.n != 0 && i != terms.length - 1) continue;
            builder.add(terms[i], i);
        }
        return builder.build();
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.phraseQuery.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((NGramPhraseQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(NGramPhraseQuery other) {
        return this.n == other.n && this.phraseQuery.equals(other.phraseQuery);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.phraseQuery.hashCode();
        h = 31 * h + this.n;
        return h;
    }

    public int getN() {
        return this.n;
    }

    public Term[] getTerms() {
        return this.phraseQuery.getTerms();
    }

    public int[] getPositions() {
        return this.phraseQuery.getPositions();
    }

    @Override
    public String toString(String field) {
        return this.phraseQuery.toString(field);
    }
}

