/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.Component2D;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.GeoUtils;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.LatLonGeometry;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.Point2D;

public final class Point
extends LatLonGeometry {
    private final double lat;
    private final double lon;

    public Point(double lat, double lon) {
        GeoUtils.checkLatitude(lat);
        GeoUtils.checkLongitude(lon);
        this.lat = lat;
        this.lon = lon;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    @Override
    protected Component2D toComponent2D() {
        return Point2D.create(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point point = (Point)o;
        return point.lat == this.lat && point.lon == this.lon;
    }

    public int hashCode() {
        int result = Double.hashCode(this.lat);
        result = 31 * result + Double.hashCode(this.lon);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Point(");
        sb.append(this.lon);
        sb.append(",");
        sb.append(this.lat);
        sb.append(')');
        return sb.toString();
    }
}

