/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.lucene87;

import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.SuppressForbidden;

@FunctionalInterface
interface BugfixDeflater_JDK8252739 {
    public static final boolean IS_BUGGY_JDK = BugfixDeflater_JDK8252739.detectBuggyJDK();

    @SuppressForbidden(reason="Works around bug, so it must call forbidden method")
    public static BugfixDeflater_JDK8252739 createBugfix(Deflater deflater) {
        if (IS_BUGGY_JDK) {
            BytesRefBuilder dictBytesScratch = new BytesRefBuilder();
            return (dictBytes, off, len) -> {
                if (off > 0) {
                    dictBytesScratch.grow(len);
                    System.arraycopy(dictBytes, off, dictBytesScratch.bytes(), 0, len);
                    deflater.setDictionary(dictBytesScratch.bytes(), 0, len);
                } else {
                    deflater.setDictionary(dictBytes, off, len);
                }
            };
        }
        return deflater::setDictionary;
    }

    public void setDictionary(byte[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="Detector for the bug, so it must call buggy method")
    public static boolean detectBuggyJDK() {
        int compressedSize;
        byte[] testData = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] compressed = new byte[32];
        Deflater deflater = new Deflater(6, true);
        try {
            deflater.reset();
            deflater.setDictionary(testData, 4, 4);
            deflater.setInput(testData);
            deflater.finish();
            compressedSize = deflater.deflate(compressed, 0, compressed.length, 3);
        }
        finally {
            deflater.end();
        }
        compressed[compressedSize] = 0;
        ++compressedSize;
        Inflater inflater = new Inflater(true);
        byte[] restored = new byte[testData.length];
        try {
            inflater.reset();
            inflater.setDictionary(testData, 4, 4);
            inflater.setInput(compressed, 0, compressedSize);
            int restoredLength = inflater.inflate(restored);
            if (restoredLength != testData.length) {
                boolean bl = true;
                return bl;
            }
        }
        catch (DataFormatException e) {
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            inflater.end();
        }
        return !Arrays.equals(testData, restored);
    }
}

