/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.compressing;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFileNames;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ChecksumIndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed.DirectMonotonicWriter;

public final class FieldsIndexWriter
implements Closeable {
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    private final Directory dir;
    private final String name;
    private final String suffix;
    private final String extension;
    private final String codecName;
    private final byte[] id;
    private final int blockShift;
    private final IOContext ioContext;
    private IndexOutput docsOut;
    private IndexOutput filePointersOut;
    private int totalDocs;
    private int totalChunks;
    private long previousFP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldsIndexWriter(Directory dir, String name, String suffix, String extension, String codecName, byte[] id, int blockShift, IOContext ioContext) throws IOException {
        this.dir = dir;
        this.name = name;
        this.suffix = suffix;
        this.extension = extension;
        this.codecName = codecName;
        this.id = id;
        this.blockShift = blockShift;
        this.ioContext = ioContext;
        this.docsOut = dir.createTempOutput(name, codecName + "-doc_ids", ioContext);
        boolean success = false;
        try {
            CodecUtil.writeHeader(this.docsOut, codecName + "Docs", 0);
            this.filePointersOut = dir.createTempOutput(name, codecName + "file_pointers", ioContext);
            CodecUtil.writeHeader(this.filePointersOut, codecName + "FilePointers", 0);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    void writeIndex(int numDocs, long startPointer) throws IOException {
        assert (startPointer >= this.previousFP);
        this.docsOut.writeVInt(numDocs);
        this.filePointersOut.writeVLong(startPointer - this.previousFP);
        this.previousFP = startPointer;
        this.totalDocs += numDocs;
        ++this.totalChunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish(int numDocs, long maxPointer, IndexOutput metaOut) throws IOException {
        if (numDocs != this.totalDocs) {
            throw new IllegalStateException("Expected " + numDocs + " docs, but got " + this.totalDocs);
        }
        CodecUtil.writeFooter(this.docsOut);
        CodecUtil.writeFooter(this.filePointersOut);
        IOUtils.close(this.docsOut, this.filePointersOut);
        try (IndexOutput dataOut = this.dir.createOutput(IndexFileNames.segmentFileName(this.name, this.suffix, this.extension), this.ioContext);){
            block52: {
                int i;
                Throwable priorE2;
                Throwable throwable;
                block51: {
                    CodecUtil.writeIndexHeader(dataOut, this.codecName + "Idx", 0, this.id, this.suffix);
                    metaOut.writeInt(numDocs);
                    metaOut.writeInt(this.blockShift);
                    metaOut.writeInt(this.totalChunks + 1);
                    metaOut.writeLong(dataOut.getFilePointer());
                    throwable = null;
                    try (ChecksumIndexInput docsIn = this.dir.openChecksumInput(this.docsOut.getName(), IOContext.READONCE);){
                        block50: {
                            CodecUtil.checkHeader(docsIn, this.codecName + "Docs", 0, 0);
                            priorE2 = null;
                            try {
                                DirectMonotonicWriter docs = DirectMonotonicWriter.getInstance(metaOut, dataOut, this.totalChunks + 1, this.blockShift);
                                long doc = 0L;
                                docs.add(doc);
                                for (i = 0; i < this.totalChunks; ++i) {
                                    docs.add(doc += (long)docsIn.readVInt());
                                }
                                docs.finish();
                                if (doc == (long)this.totalDocs) break block50;
                                throw new CorruptIndexException("Docs don't add up", docsIn);
                            }
                            catch (Throwable e) {
                                try {
                                    priorE2 = e;
                                    break block51;
                                }
                                catch (Throwable throwable2) {
                                    throw throwable2;
                                }
                                finally {
                                    CodecUtil.checkFooter(docsIn, priorE2);
                                }
                            }
                        }
                        CodecUtil.checkFooter(docsIn, priorE2);
                    }
                    catch (Throwable priorE2) {
                        throwable = priorE2;
                        throw priorE2;
                    }
                }
                this.dir.deleteFile(this.docsOut.getName());
                this.docsOut = null;
                metaOut.writeLong(dataOut.getFilePointer());
                throwable = null;
                try (ChecksumIndexInput filePointersIn = this.dir.openChecksumInput(this.filePointersOut.getName(), IOContext.READONCE);){
                    CodecUtil.checkHeader(filePointersIn, this.codecName + "FilePointers", 0, 0);
                    priorE2 = null;
                    try {
                        DirectMonotonicWriter filePointers = DirectMonotonicWriter.getInstance(metaOut, dataOut, this.totalChunks + 1, this.blockShift);
                        long fp = 0L;
                        for (i = 0; i < this.totalChunks; ++i) {
                            filePointers.add(fp += filePointersIn.readVLong());
                        }
                        if (maxPointer < fp) {
                            throw new CorruptIndexException("File pointers don't add up", filePointersIn);
                        }
                        filePointers.add(maxPointer);
                        filePointers.finish();
                    }
                    catch (Throwable e) {
                        try {
                            priorE2 = e;
                            break block52;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                        finally {
                            CodecUtil.checkFooter(filePointersIn, priorE2);
                        }
                    }
                    CodecUtil.checkFooter(filePointersIn, priorE2);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            this.dir.deleteFile(this.filePointersOut.getName());
            this.filePointersOut = null;
            metaOut.writeLong(dataOut.getFilePointer());
            metaOut.writeLong(maxPointer);
            CodecUtil.writeFooter(dataOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.docsOut, this.filePointersOut);
        }
        finally {
            ArrayList<String> fileNames = new ArrayList<String>();
            if (this.docsOut != null) {
                fileNames.add(this.docsOut.getName());
            }
            if (this.filePointersOut != null) {
                fileNames.add(this.filePointersOut.getName());
            }
            try {
                IOUtils.deleteFiles(this.dir, fileNames);
            }
            finally {
                this.filePointersOut = null;
                this.docsOut = null;
            }
        }
    }
}

