/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.table;

import java.time.Duration;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.elasticsearch.sink.FlushBackoffType;

@PublicEvolving
public class ElasticsearchConnectorOptions {
    public static final ConfigOption<List<String>> HOSTS_OPTION = ConfigOptions.key((String)"hosts").stringType().asList().noDefaultValue().withDescription("Elasticsearch hosts to connect to.");
    public static final ConfigOption<String> INDEX_OPTION = ConfigOptions.key((String)"index").stringType().noDefaultValue().withDescription("Elasticsearch index for every record.");
    public static final ConfigOption<String> PASSWORD_OPTION = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password used to connect to Elasticsearch instance.");
    public static final ConfigOption<String> USERNAME_OPTION = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Username used to connect to Elasticsearch instance.");
    public static final ConfigOption<String> KEY_DELIMITER_OPTION = ConfigOptions.key((String)"document-id.key-delimiter").stringType().defaultValue((Object)"_").withDescription("Delimiter for composite keys e.g., \"$\" would result in IDs \"KEY1$KEY2$KEY3\".");
    public static final ConfigOption<Integer> BULK_FLUSH_MAX_ACTIONS_OPTION = ConfigOptions.key((String)"sink.bulk-flush.max-actions").intType().defaultValue((Object)1000).withDescription("Maximum number of actions to buffer for each bulk request.");
    public static final ConfigOption<MemorySize> BULK_FLUSH_MAX_SIZE_OPTION = ConfigOptions.key((String)"sink.bulk-flush.max-size").memoryType().defaultValue((Object)MemorySize.parse((String)"2mb")).withDescription("Maximum size of buffered actions per bulk request");
    public static final ConfigOption<Duration> BULK_FLUSH_INTERVAL_OPTION = ConfigOptions.key((String)"sink.bulk-flush.interval").durationType().defaultValue((Object)Duration.ofSeconds(1L)).withDescription("Bulk flush interval");
    public static final ConfigOption<FlushBackoffType> BULK_FLUSH_BACKOFF_TYPE_OPTION = ConfigOptions.key((String)"sink.bulk-flush.backoff.strategy").enumType(FlushBackoffType.class).noDefaultValue().withDescription("Backoff strategy");
    public static final ConfigOption<Integer> BULK_FLUSH_BACKOFF_MAX_RETRIES_OPTION = ConfigOptions.key((String)"sink.bulk-flush.backoff.max-retries").intType().noDefaultValue().withDescription("Maximum number of retries.");
    public static final ConfigOption<Duration> BULK_FLUSH_BACKOFF_DELAY_OPTION = ConfigOptions.key((String)"sink.bulk-flush.backoff.delay").durationType().noDefaultValue().withDescription("Delay between each backoff attempt.");
    public static final ConfigOption<String> CONNECTION_PATH_PREFIX_OPTION = ConfigOptions.key((String)"connection.path-prefix").stringType().noDefaultValue().withDescription("Prefix string to be added to every REST communication.");
    public static final ConfigOption<Duration> CONNECTION_REQUEST_TIMEOUT = ConfigOptions.key((String)"connection.request-timeout").durationType().noDefaultValue().withDescription("The timeout for requesting a connection from the connection manager.");
    public static final ConfigOption<Duration> CONNECTION_TIMEOUT = ConfigOptions.key((String)"connection.timeout").durationType().noDefaultValue().withDescription("The timeout for establishing a connection.");
    public static final ConfigOption<Duration> SOCKET_TIMEOUT = ConfigOptions.key((String)"socket.timeout").durationType().noDefaultValue().withDescription("The socket timeout (SO_TIMEOUT) for waiting for data or, put differently,a maximum period inactivity between two consecutive data packets.");
    public static final ConfigOption<String> FORMAT_OPTION = ConfigOptions.key((String)"format").stringType().defaultValue((Object)"json").withDescription("The format must produce a valid JSON document. Please refer to the documentation on formats for more details.");
    public static final ConfigOption<DeliveryGuarantee> DELIVERY_GUARANTEE_OPTION = ConfigOptions.key((String)"sink.delivery-guarantee").enumType(DeliveryGuarantee.class).defaultValue((Object)DeliveryGuarantee.AT_LEAST_ONCE).withDescription("Optional delivery guarantee when committing.");

    ElasticsearchConnectorOptions() {
    }
}

