/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.cdc.common.utils.StringUtils;
import org.apache.flink.cdc.runtime.operators.transform.UserDefinedFunctionDescriptor;
import org.apache.flink.cdc.runtime.operators.transform.exceptions.TransformException;
import org.apache.flink.cdc.runtime.parser.TransformParser;

public class TransformFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final String scriptExpression;
    private final List<String> columnNames;
    private final Map<String, String> columnNameMap;

    public TransformFilter(String expression, String scriptExpression, List<String> columnNames, Map<String, String> columnNameMap) {
        this.expression = expression;
        this.scriptExpression = scriptExpression;
        this.columnNames = columnNames;
        this.columnNameMap = columnNameMap;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getScriptExpression() {
        return this.scriptExpression;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public Map<String, String> getColumnNameMap() {
        return this.columnNameMap;
    }

    public String getColumnNameMapAsString() {
        return TransformException.prettyPrintColumnNameMap(this.getColumnNameMap());
    }

    public static Optional<TransformFilter> of(String filterExpression, List<UserDefinedFunctionDescriptor> udfDescriptors) {
        if (StringUtils.isNullOrWhitespaceOnly(filterExpression)) {
            return Optional.empty();
        }
        List<String> columnNames = TransformParser.parseFilterColumnNameList(filterExpression);
        Map<String, String> columnNameMap = TransformParser.generateColumnNameMap(columnNames);
        String scriptExpression = TransformParser.translateFilterExpressionToJaninoExpression(filterExpression, udfDescriptors, columnNameMap);
        return Optional.of(new TransformFilter(filterExpression, scriptExpression, columnNames, columnNameMap));
    }

    public boolean isValid() {
        return !this.columnNames.isEmpty();
    }

    public String toString() {
        return "TransformFilter{expression='" + this.expression + '\'' + ", scriptExpression='" + this.scriptExpression + '\'' + ", columnNames=" + this.columnNames + ", columnNameMap=" + this.columnNameMap + '}';
    }
}

