/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.Node;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class DescribeClusterResponse
extends AbstractResponse {
    private final DescribeClusterResponseData data;

    public DescribeClusterResponse(DescribeClusterResponseData data) {
        super(ApiKeys.DESCRIBE_CLUSTER);
        this.data = data;
    }

    public Map<Integer, Node> nodes() {
        return this.data.brokers().valuesList().stream().map(b -> new Node(b.brokerId(), b.host(), b.port(), b.rack())).collect(Collectors.toMap(Node::id, Function.identity()));
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(Errors.forCode(this.data.errorCode()));
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public DescribeClusterResponseData data() {
        return this.data;
    }

    public static DescribeClusterResponse parse(ByteBuffer buffer, short version) {
        return new DescribeClusterResponse(new DescribeClusterResponseData(new ByteBufferAccessor(buffer), version));
    }
}

