/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql.validate.SqlValidatorWithHints;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.source.SupportedMetadataColumn;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.cdc.common.utils.StringUtils;
import org.apache.flink.cdc.runtime.operators.transform.ProjectionColumn;
import org.apache.flink.cdc.runtime.operators.transform.UserDefinedFunctionDescriptor;
import org.apache.flink.cdc.runtime.parser.JaninoCompiler;
import org.apache.flink.cdc.runtime.parser.metadata.MetadataColumns;
import org.apache.flink.cdc.runtime.parser.metadata.TransformSchemaFactory;
import org.apache.flink.cdc.runtime.parser.metadata.TransformSqlOperatorTable;
import org.apache.flink.cdc.runtime.typeutils.DataTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformParser {
    private static final Logger LOG = LoggerFactory.getLogger(TransformParser.class);
    private static final String DEFAULT_SCHEMA = "default_schema";
    private static final String DEFAULT_TABLE = "TB";
    private static final String MAPPED_COLUMN_NAME_PREFIX = "$";
    private static final String MAPPED_SINGLE_COLUMN_NAME = "$0";

    private static SqlParser getCalciteParser(String sql) {
        return SqlParser.create((String)sql, (SqlParser.Config)SqlParser.Config.DEFAULT.withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).withCaseSensitive(true).withLex(Lex.JAVA));
    }

    private static RelNode sqlToRel(List<Column> columns, SqlNode sqlNode, List<UserDefinedFunctionDescriptor> udfDescriptors, SupportedMetadataColumn[] supportedMetadataColumns) {
        List<Column> columnsWithMetadata = TransformParser.copyFillMetadataColumn(columns, supportedMetadataColumns);
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)true);
        SchemaPlus schema = rootSchema.plus();
        HashMap<String, Object> operand = new HashMap<String, Object>();
        operand.put("tableName", DEFAULT_TABLE);
        operand.put("columns", columnsWithMetadata);
        rootSchema.add(DEFAULT_SCHEMA, TransformSchemaFactory.INSTANCE.create(schema, DEFAULT_SCHEMA, operand));
        ArrayList<SqlFunction> udfFunctions = new ArrayList<SqlFunction>();
        for (UserDefinedFunctionDescriptor udf : udfDescriptors) {
            try {
                Class<?> clazz = Class.forName(udf.getClasspath());
                ScalarFunction function = ScalarFunctionImpl.create(clazz, (String)"eval");
                Preconditions.checkNotNull(function, "UDF function must provide at least one `eval` method.");
                SqlReturnTypeInference returnTypeInference = udf.getReturnTypeHint() != null ? o -> {
                    RelDataTypeFactory typeFactory = o.getTypeFactory();
                    DataType returnTypeHint = udf.getReturnTypeHint();
                    return DataTypeConverter.convertCalciteType(typeFactory, returnTypeHint);
                } : o -> function.getReturnType(o.getTypeFactory());
                schema.add(udf.getName(), (Function)function);
                udfFunctions.add(new SqlFunction(udf.getName(), SqlKind.OTHER_FUNCTION, returnTypeInference, InferTypes.RETURN_TYPE, OperandTypes.VARIADIC, SqlFunctionCategory.USER_DEFINED_FUNCTION));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to resolve UDF: " + udf, e);
            }
        }
        SqlTypeFactoryImpl factory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        CalciteCatalogReader calciteCatalogReader = new CalciteCatalogReader(rootSchema, rootSchema.path(DEFAULT_SCHEMA), (RelDataTypeFactory)factory, (CalciteConnectionConfig)new CalciteConnectionConfigImpl(new Properties()));
        TransformSqlOperatorTable transformSqlOperatorTable = TransformSqlOperatorTable.instance();
        SqlOperatorTable udfOperatorTable = SqlOperatorTables.of(udfFunctions);
        SqlValidatorWithHints validator = SqlValidatorUtil.newValidator((SqlOperatorTable)SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{transformSqlOperatorTable, udfOperatorTable}), (SqlValidatorCatalogReader)calciteCatalogReader, (RelDataTypeFactory)factory, (SqlValidator.Config)SqlValidator.Config.DEFAULT.withIdentifierExpansion(true).withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5));
        SqlNode validateSqlNode = validator.validate(sqlNode);
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter(null, (SqlValidator)validator, (Prepare.CatalogReader)calciteCatalogReader, RelOptCluster.create((RelOptPlanner)new HepPlanner(new HepProgramBuilder().build()), (RexBuilder)new RexBuilder((RelDataTypeFactory)factory)), (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, SqlToRelConverter.config().withTrimUnusedFields(true));
        RelRoot relRoot = sqlToRelConverter.convertQuery(validateSqlNode, false, false);
        return relRoot.rel;
    }

    public static SqlSelect parseSelect(String statement) {
        SqlNode sqlNode;
        try {
            sqlNode = TransformParser.getCalciteParser(statement).parseQuery();
        }
        catch (SqlParseException e) {
            LOG.error("Statements can not be parsed. {} \n {}", (Object)statement, (Object)e);
            throw new ParseException("Statements can not be parsed.", (Throwable)e);
        }
        if (sqlNode instanceof SqlSelect) {
            return (SqlSelect)sqlNode;
        }
        throw new ParseException("Only select statements can be parsed.");
    }

    public static List<Column> generateReferencedColumns(String projectionExpression, @Nullable String filterExpression, List<Column> columns) {
        if (StringUtils.isNullOrWhitespaceOnly(projectionExpression)) {
            return new ArrayList<Column>();
        }
        HashSet<String> referencedColumnNames = new HashSet<String>();
        SqlSelect sqlProject = TransformParser.parseProjectionExpression(projectionExpression);
        if (!sqlProject.getSelectList().isEmpty()) {
            for (SqlNode sqlNode : sqlProject.getSelectList()) {
                if (sqlNode instanceof SqlBasicCall) {
                    SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
                    if (SqlKind.AS.equals((Object)sqlBasicCall.getOperator().kind)) {
                        referencedColumnNames.addAll(TransformParser.parseColumnNameList((SqlNode)sqlBasicCall.getOperandList().get(0)));
                        continue;
                    }
                    throw new ParseException("Unrecognized projection expression: " + sqlBasicCall + ". Should be <EXPR> AS <IDENTIFIER>");
                }
                if (!(sqlNode instanceof SqlIdentifier)) continue;
                SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
                if (sqlIdentifier.isStar()) {
                    return columns;
                }
                referencedColumnNames.add((String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1));
            }
        }
        if (!StringUtils.isNullOrWhitespaceOnly(projectionExpression)) {
            SqlSelect sqlFilter = TransformParser.parseFilterExpression(filterExpression);
            referencedColumnNames.addAll(TransformParser.parseColumnNameList(sqlFilter.getWhere()));
        }
        return columns.stream().filter(e -> referencedColumnNames.contains(e.getName())).collect(Collectors.toList());
    }

    private static void expandWildcard(SqlSelect sqlSelect, List<Column> columns) {
        ArrayList<SqlNode> expandedNodes = new ArrayList<SqlNode>();
        for (SqlNode sqlNode : sqlSelect.getSelectList().getList()) {
            if (sqlNode instanceof SqlIdentifier && ((SqlIdentifier)sqlNode).isStar()) {
                expandedNodes.addAll(columns.stream().map(c -> new SqlIdentifier(c.getName(), SqlParserPos.QUOTED_ZERO)).collect(Collectors.toList()));
                continue;
            }
            expandedNodes.add(sqlNode);
        }
        sqlSelect.setSelectList(new SqlNodeList(expandedNodes, SqlParserPos.ZERO));
    }

    public static List<ProjectionColumn> generateProjectionColumns(String projectionExpression, List<Column> columns, List<UserDefinedFunctionDescriptor> udfDescriptors, SupportedMetadataColumn[] supportedMetadataColumns) {
        if (StringUtils.isNullOrWhitespaceOnly(projectionExpression)) {
            return new ArrayList<ProjectionColumn>();
        }
        SqlSelect sqlSelect = TransformParser.parseProjectionExpression(projectionExpression);
        if (sqlSelect.getSelectList().isEmpty()) {
            return new ArrayList<ProjectionColumn>();
        }
        TransformParser.expandWildcard(sqlSelect, columns);
        RelNode relNode = TransformParser.sqlToRel(columns, (SqlNode)sqlSelect, udfDescriptors, supportedMetadataColumns);
        RelDataType[] relDataTypes = (RelDataType[])relNode.getRowType().getFieldList().stream().map(RelDataTypeField::getType).toArray(RelDataType[]::new);
        Map<String, Column> originalColumnMap = columns.stream().collect(Collectors.toMap(Column::getName, column -> column));
        ArrayList<ProjectionColumn> projectionColumns = new ArrayList<ProjectionColumn>();
        HashMap<String, Integer> addedProjectionColumnNames = new HashMap<String, Integer>();
        SqlNodeList selectExpressionList = sqlSelect.getSelectList();
        for (int i = 0; i < selectExpressionList.size(); ++i) {
            ProjectionColumn projectionColumn;
            SqlNode sqlNode = selectExpressionList.get(i);
            RelDataType relDataType = relDataTypes[i];
            if (sqlNode instanceof SqlBasicCall) {
                SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
                List operandList = sqlBasicCall.getOperandList();
                Preconditions.checkArgument(SqlKind.AS.equals((Object)sqlBasicCall.getOperator().kind) && operandList.size() == 2 && operandList.get(1) instanceof SqlIdentifier, "Unrecognized projection expression: " + sqlBasicCall + ". Should be <EXPR> AS <IDENTIFIER>", new Object[0]);
                SqlIdentifier aliasNode = (SqlIdentifier)operandList.get(1);
                String columnName = (String)aliasNode.names.get(aliasNode.names.size() - 1);
                Preconditions.checkArgument(!TransformParser.isMetadataColumn(columnName, supportedMetadataColumns), "Column name %s is reserved and shading it is not allowed.", columnName);
                SqlNode exprNode = (SqlNode)operandList.get(0);
                if (exprNode instanceof SqlIdentifier) {
                    SqlIdentifier identifierExprNode = (SqlIdentifier)exprNode;
                    String originalName = (String)identifierExprNode.names.get(identifierExprNode.names.size() - 1);
                    projectionColumn = TransformParser.resolveProjectionColumnFromIdentifier(relDataType, originalColumnMap, originalName, columnName, supportedMetadataColumns);
                } else {
                    List<String> originalColumnNames = TransformParser.parseColumnNameList(exprNode);
                    Map<String, String> columnNameMap = TransformParser.generateColumnNameMap(originalColumnNames);
                    projectionColumn = ProjectionColumn.ofCalculated(columnName, DataTypeConverter.convertCalciteRelDataTypeToDataType(relDataType), exprNode.toString(), JaninoCompiler.translateSqlNodeToJaninoExpression(exprNode, udfDescriptors, columnNameMap), originalColumnNames, columnNameMap);
                }
            } else if (sqlNode instanceof SqlIdentifier) {
                SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
                String columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
                projectionColumn = TransformParser.resolveProjectionColumnFromIdentifier(relDataType, originalColumnMap, columnName, columnName, supportedMetadataColumns);
            } else {
                throw new ParseException("Unrecognized projection: " + sqlNode.toString());
            }
            String projectionColumnName = projectionColumn.getColumnName();
            if (addedProjectionColumnNames.containsKey(projectionColumnName)) {
                projectionColumns.set((Integer)addedProjectionColumnNames.get(projectionColumnName), projectionColumn);
                continue;
            }
            projectionColumns.add(projectionColumn);
            addedProjectionColumnNames.put(projectionColumnName, projectionColumns.size() - 1);
        }
        return projectionColumns;
    }

    public static ProjectionColumn resolveProjectionColumnFromIdentifier(RelDataType relDataType, Map<String, Column> originalColumnMap, String identifier, String projectedColumnName, SupportedMetadataColumn[] supportedMetadataColumns) {
        Map<String, String> columnNameMap = Collections.singletonMap(identifier, MAPPED_SINGLE_COLUMN_NAME);
        if (TransformParser.isMetadataColumn(identifier, supportedMetadataColumns)) {
            return ProjectionColumn.ofCalculated(projectedColumnName, DataTypeConverter.convertCalciteRelDataTypeToDataType(relDataType).notNull(), identifier, columnNameMap.get(identifier), Collections.singletonList(identifier), columnNameMap);
        }
        Preconditions.checkArgument(originalColumnMap.containsKey(identifier), "Referenced column %s is not present in original table.", identifier);
        Column column = originalColumnMap.get(identifier);
        if (Objects.equals(identifier, projectedColumnName)) {
            return ProjectionColumn.ofForwarded(column, MAPPED_SINGLE_COLUMN_NAME);
        }
        return ProjectionColumn.ofAliased(column, projectedColumnName, MAPPED_SINGLE_COLUMN_NAME);
    }

    public static String translateFilterExpressionToJaninoExpression(String filterExpression, List<UserDefinedFunctionDescriptor> udfDescriptors, Map<String, String> columnNameMap) {
        if (StringUtils.isNullOrWhitespaceOnly(filterExpression)) {
            return "";
        }
        SqlSelect sqlSelect = TransformParser.parseFilterExpression(filterExpression);
        if (!sqlSelect.hasWhere()) {
            return "";
        }
        SqlNode where = sqlSelect.getWhere();
        return JaninoCompiler.translateSqlNodeToJaninoExpression(where, udfDescriptors, columnNameMap);
    }

    public static List<String> parseComputedColumnNames(String projection, SupportedMetadataColumn[] supportedMetadataColumns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        if (StringUtils.isNullOrWhitespaceOnly(projection)) {
            return columnNames;
        }
        SqlSelect sqlSelect = TransformParser.parseProjectionExpression(projection);
        if (sqlSelect.getSelectList().isEmpty()) {
            return columnNames;
        }
        for (SqlNode sqlNode : sqlSelect.getSelectList()) {
            if (sqlNode instanceof SqlBasicCall) {
                SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
                if (SqlKind.AS.equals((Object)sqlBasicCall.getOperator().kind)) {
                    String columnName = null;
                    List operandList = sqlBasicCall.getOperandList();
                    for (SqlNode operand : operandList) {
                        if (!(operand instanceof SqlIdentifier)) continue;
                        SqlIdentifier sqlIdentifier = (SqlIdentifier)operand;
                        columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
                    }
                    if (columnNames.contains(columnName)) {
                        throw new ParseException("Duplicate column definitions: " + columnName);
                    }
                    columnNames.add(columnName);
                    continue;
                }
                throw new ParseException("Unrecognized projection: " + sqlBasicCall);
            }
            if (sqlNode instanceof SqlIdentifier) {
                String columnName = sqlNode.toString();
                if (!TransformParser.isMetadataColumn(columnName, supportedMetadataColumns) || columnNames.contains(columnName)) continue;
                columnNames.add(columnName);
                continue;
            }
            throw new ParseException("Unrecognized projection: " + sqlNode.toString());
        }
        return columnNames;
    }

    public static List<String> parseFilterColumnNameList(String filterExpression) {
        if (StringUtils.isNullOrWhitespaceOnly(filterExpression)) {
            return new ArrayList<String>();
        }
        SqlSelect sqlSelect = TransformParser.parseFilterExpression(filterExpression);
        if (!sqlSelect.hasWhere()) {
            return new ArrayList<String>();
        }
        SqlNode where = sqlSelect.getWhere();
        return TransformParser.parseColumnNameList(where);
    }

    private static List<String> parseColumnNameList(SqlNode sqlNode) {
        ArrayList<String> columnNameList = new ArrayList<String>();
        if (sqlNode instanceof SqlIdentifier) {
            SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
            String columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
            columnNameList.add(columnName);
        } else if (sqlNode instanceof SqlCall) {
            SqlCall sqlCall = (SqlCall)sqlNode;
            TransformParser.findSqlIdentifier(sqlCall.getOperandList(), columnNameList);
        } else if (sqlNode instanceof SqlNodeList) {
            SqlNodeList sqlNodeList = (SqlNodeList)sqlNode;
            TransformParser.findSqlIdentifier(sqlNodeList.getList(), columnNameList);
        }
        return columnNameList;
    }

    private static void findSqlIdentifier(List<SqlNode> sqlNodes, List<String> columnNameList) {
        for (SqlNode sqlNode : sqlNodes) {
            if (sqlNode instanceof SqlIdentifier) {
                SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
                String columnName = (String)sqlIdentifier.names.get(sqlIdentifier.names.size() - 1);
                columnNameList.add(columnName);
                continue;
            }
            if (sqlNode instanceof SqlCall) {
                SqlCall sqlCall = (SqlCall)sqlNode;
                TransformParser.findSqlIdentifier(sqlCall.getOperandList(), columnNameList);
                continue;
            }
            if (!(sqlNode instanceof SqlNodeList)) continue;
            SqlNodeList sqlNodeList = (SqlNodeList)sqlNode;
            TransformParser.findSqlIdentifier(sqlNodeList.getList(), columnNameList);
        }
    }

    private static SqlSelect parseProjectionExpression(String projection) {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT ");
        statement.append(projection);
        statement.append(" FROM ");
        statement.append(DEFAULT_TABLE);
        return TransformParser.parseSelect(statement.toString());
    }

    private static List<Column> copyFillMetadataColumn(List<Column> columns, SupportedMetadataColumn[] supportedMetadataColumns) {
        ArrayList<Column> columnsWithMetadata = new ArrayList<Column>(columns);
        MetadataColumns.METADATA_COLUMNS.stream().map(col -> Column.physicalColumn((String)col.f0, (DataType)col.f1)).forEach(columnsWithMetadata::add);
        Stream.of(supportedMetadataColumns).map(sCol -> Column.physicalColumn(sCol.getName(), sCol.getType())).forEach(columnsWithMetadata::add);
        return columnsWithMetadata;
    }

    private static boolean isMetadataColumn(String columnName, SupportedMetadataColumn[] supportedMetadataColumns) {
        return MetadataColumns.METADATA_COLUMNS.stream().anyMatch(col -> ((String)col.f0).equals(columnName)) || Stream.of(supportedMetadataColumns).anyMatch(col -> col.getName().equals(columnName));
    }

    public static SqlSelect parseFilterExpression(String filterExpression) {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT * FROM ");
        statement.append(DEFAULT_TABLE);
        if (!StringUtils.isNullOrWhitespaceOnly(filterExpression)) {
            statement.append(" WHERE ");
            statement.append(filterExpression);
        }
        return TransformParser.parseSelect(statement.toString());
    }

    public static boolean hasAsterisk(@Nullable String projection) {
        if (StringUtils.isNullOrWhitespaceOnly(projection)) {
            return true;
        }
        return TransformParser.parseProjectionExpression(projection).getOperandList().stream().anyMatch(TransformParser::hasAsterisk);
    }

    private static boolean hasAsterisk(SqlNode sqlNode) {
        if (sqlNode instanceof SqlIdentifier) {
            return ((SqlIdentifier)sqlNode).isStar();
        }
        if (sqlNode instanceof SqlBasicCall) {
            SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
            return sqlBasicCall.getOperandList().stream().anyMatch(TransformParser::hasAsterisk);
        }
        if (sqlNode instanceof SqlNodeList) {
            SqlNodeList sqlNodeList = (SqlNodeList)sqlNode;
            return sqlNodeList.getList().stream().anyMatch(TransformParser::hasAsterisk);
        }
        return false;
    }

    public static Map<String, String> generateColumnNameMap(List<String> originalColumnNames) {
        int i = 0;
        HashMap<String, String> columnNameMap = new HashMap<String, String>();
        for (String columnName : originalColumnNames) {
            if (columnNameMap.containsKey(columnName)) continue;
            columnNameMap.put(columnName, MAPPED_COLUMN_NAME_PREFIX + i);
            ++i;
        }
        return columnNameMap;
    }
}

