/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.schema.distributed.event;

import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;

public class SchemaChangeRequest
implements CoordinationRequest {
    private final int sourceSubTaskId;
    private final int sinkSubTaskId;
    private final SchemaChangeEvent schemaChangeEvent;

    public static SchemaChangeRequest createNoOpRequest(int sinkSubTaskId) {
        return new SchemaChangeRequest(-1, sinkSubTaskId, null);
    }

    public SchemaChangeRequest(int sourceSubTaskId, int sinkSubTaskId, SchemaChangeEvent schemaChangeEvent) {
        this.sourceSubTaskId = sourceSubTaskId;
        this.sinkSubTaskId = sinkSubTaskId;
        this.schemaChangeEvent = schemaChangeEvent;
    }

    public boolean isNoOpRequest() {
        return this.sourceSubTaskId == -1 || this.schemaChangeEvent == null;
    }

    public int getSourceSubTaskId() {
        Preconditions.checkState(!this.isNoOpRequest(), "Unable to fetch source subTaskId for an align event.");
        return this.sourceSubTaskId;
    }

    public int getSinkSubTaskId() {
        return this.sinkSubTaskId;
    }

    public SchemaChangeEvent getSchemaChangeEvent() {
        Preconditions.checkState(!this.isNoOpRequest(), "Unable to fetch source subTaskId for an align event.");
        return this.schemaChangeEvent;
    }
}

