/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.udf.UserDefinedFunction;
import org.apache.flink.table.functions.ScalarFunction;

@Internal
public class UserDefinedFunctionDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String classpath;
    private final String className;
    private final DataType returnTypeHint;
    private final boolean isCdcPipelineUdf;

    public UserDefinedFunctionDescriptor(String name, String classpath) {
        this.name = name;
        this.classpath = classpath;
        this.className = classpath.substring(classpath.lastIndexOf(46) + 1);
        try {
            Class<?> clazz = Class.forName(classpath);
            this.isCdcPipelineUdf = this.isCdcPipelineUdf(clazz);
            this.returnTypeHint = this.isCdcPipelineUdf ? (DataType)clazz.getMethod("getReturnType", new Class[0]).invoke(clazz.newInstance(), new Object[0]) : null;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to instantiate UDF " + name + "@" + classpath, e);
        }
    }

    private boolean isCdcPipelineUdf(Class<?> clazz) {
        Class<UserDefinedFunction> cdcPipelineUdfClazz = UserDefinedFunction.class;
        Class<ScalarFunction> flinkScalarFunctionClazz = ScalarFunction.class;
        if (Arrays.stream(clazz.getInterfaces()).map(Class::getName).collect(Collectors.toList()).contains(cdcPipelineUdfClazz.getName())) {
            return true;
        }
        if (clazz.getSuperclass().getName().equals(flinkScalarFunctionClazz.getName())) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Failed to detect UDF class " + clazz + " since it never implements %s or extends Flink %s.", cdcPipelineUdfClazz, flinkScalarFunctionClazz));
    }

    public DataType getReturnTypeHint() {
        return this.returnTypeHint;
    }

    public boolean isCdcPipelineUdf() {
        return this.isCdcPipelineUdf;
    }

    public String getName() {
        return this.name;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDefinedFunctionDescriptor context = (UserDefinedFunctionDescriptor)o;
        return Objects.equals(this.name, context.name) && Objects.equals(this.classpath, context.classpath);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.classpath);
    }

    public String toString() {
        return "UserDefinedFunctionDescriptor{name='" + this.name + '\'' + ", classpath='" + this.classpath + '\'' + '}';
    }
}

