/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.requests.AddPartitionsToTxnResponse;

public class AddPartitionsToTxnRequest
extends AbstractRequest {
    private final AddPartitionsToTxnRequestData data;
    private List<TopicPartition> cachedPartitions = null;

    public AddPartitionsToTxnRequest(AddPartitionsToTxnRequestData data, short version) {
        super(ApiKeys.ADD_PARTITIONS_TO_TXN, version);
        this.data = data;
    }

    public List<TopicPartition> partitions() {
        if (this.cachedPartitions != null) {
            return this.cachedPartitions;
        }
        this.cachedPartitions = Builder.getPartitions(this.data);
        return this.cachedPartitions;
    }

    @Override
    public AddPartitionsToTxnRequestData data() {
        return this.data;
    }

    @Override
    public AddPartitionsToTxnResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        for (TopicPartition partition : this.partitions()) {
            errors.put(partition, Errors.forException(e));
        }
        return new AddPartitionsToTxnResponse(throttleTimeMs, errors);
    }

    public static AddPartitionsToTxnRequest parse(ByteBuffer buffer, short version) {
        return new AddPartitionsToTxnRequest(new AddPartitionsToTxnRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AddPartitionsToTxnRequest> {
        public final AddPartitionsToTxnRequestData data;

        public Builder(AddPartitionsToTxnRequestData data) {
            super(ApiKeys.ADD_PARTITIONS_TO_TXN);
            this.data = data;
        }

        public Builder(String transactionalId, long producerId, short producerEpoch, List<TopicPartition> partitions) {
            super(ApiKeys.ADD_PARTITIONS_TO_TXN);
            HashMap<String, List> partitionMap = new HashMap<String, List>();
            for (TopicPartition topicPartition : partitions) {
                String topicName = topicPartition.topic();
                partitionMap.compute(topicName, (key, subPartitions) -> {
                    if (subPartitions == null) {
                        subPartitions = new ArrayList<Integer>();
                    }
                    subPartitions.add(topicPartition.partition());
                    return subPartitions;
                });
            }
            AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection topics = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection();
            for (Map.Entry partitionEntry : partitionMap.entrySet()) {
                topics.add(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName((String)partitionEntry.getKey()).setPartitions((List)partitionEntry.getValue()));
            }
            this.data = new AddPartitionsToTxnRequestData().setTransactionalId(transactionalId).setProducerId(producerId).setProducerEpoch(producerEpoch).setTopics(topics);
        }

        @Override
        public AddPartitionsToTxnRequest build(short version) {
            return new AddPartitionsToTxnRequest(this.data, version);
        }

        static List<TopicPartition> getPartitions(AddPartitionsToTxnRequestData data) {
            ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
            for (AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic topicCollection : data.topics()) {
                for (Integer partition : topicCollection.partitions()) {
                    partitions.add(new TopicPartition(topicCollection.name(), partition));
                }
            }
            return partitions;
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

