/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.db2.source.utils;

import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Db2DatabaseSchema;
import io.debezium.connector.db2.Db2TopicSelector;
import io.debezium.connector.db2.Lsn;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.db2.source.offset.LsnOffset;
import org.apache.flink.cdc.connectors.db2.source.utils.Db2TypeUtils;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.FlinkRuntimeException;

public class Db2Utils {
    private static final String EVENT_SERIAL_NO_KEY = "event_serial_no";

    public static long queryApproximateRowCnt(JdbcConnection jdbc, TableId tableId) throws SQLException {
        String rowCountQuery = String.format("SELECT CARD\nFROM SYSCAT.TABLES\nWHERE TABSCHEMA='%s' and TABNAME='%s';", tableId.schema(), tableId.table());
        return jdbc.queryAndMap(rowCountQuery, rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", rowCountQuery));
            }
            return rs.getLong(1);
        });
    }

    public static Object queryNextChunkMax(JdbcConnection jdbc, TableId tableId, String splitColumnName, int chunkSize, Object includedLowerBound) throws SQLException {
        String quotedColumn = Db2Utils.quote(splitColumnName);
        String query = String.format("SELECT MAX(%s) FROM (SELECT %s FROM %s WHERE %s >= ? ORDER BY %s ASC  FETCH FIRST %S ROWS ONLY ) AS T", quotedColumn, quotedColumn, Db2Utils.quote(tableId), quotedColumn, quotedColumn, chunkSize);
        return jdbc.prepareQueryAndMap(query, ps -> ps.setObject(1, includedLowerBound), rs -> {
            if (!rs.next()) {
                throw new SQLException(String.format("No result returned after running query [%s]", query));
            }
            return rs.getObject(1);
        });
    }

    public static Column getSplitColumn(Table table, @Nullable String chunkKeyColumn) {
        List<Column> primaryKeys = table.primaryKeyColumns();
        if (primaryKeys.isEmpty()) {
            throw new ValidationException(String.format("Incremental snapshot for tables requires primary key, but table %s doesn't have primary key.", table.id()));
        }
        if (chunkKeyColumn != null) {
            Optional<Column> targetPkColumn = primaryKeys.stream().filter(col -> chunkKeyColumn.equals(col.name())).findFirst();
            if (targetPkColumn.isPresent()) {
                return targetPkColumn.get();
            }
            throw new ValidationException(String.format("Chunk key column '%s' doesn't exist in the primary key [%s] of the table %s.", chunkKeyColumn, primaryKeys.stream().map(Column::name).collect(Collectors.joining(",")), table.id()));
        }
        return primaryKeys.get(0);
    }

    public static RowType getSplitType(Column splitColumn) {
        return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)splitColumn.name(), (DataType)Db2TypeUtils.fromDbzColumn(splitColumn))}).getLogicalType();
    }

    public static Offset getLsn(SourceRecord record) {
        return Db2Utils.getLsnPosition(record.sourceOffset());
    }

    public static LsnOffset getLsnPosition(Map<String, ?> offset) {
        HashMap<String, String> offsetStrMap = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : offset.entrySet()) {
            offsetStrMap.put(entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
        }
        Lsn changeLsn = Lsn.valueOf((String)offsetStrMap.get("change_lsn"));
        Lsn commitLsn = Lsn.valueOf((String)offsetStrMap.get("commit_lsn"));
        Long eventSerialNo = null;
        if (offsetStrMap.get(EVENT_SERIAL_NO_KEY) != null) {
            eventSerialNo = Long.parseLong((String)offsetStrMap.get(EVENT_SERIAL_NO_KEY));
        }
        return new LsnOffset(changeLsn, commitLsn, eventSerialNo);
    }

    public static LsnOffset currentLsn(Db2Connection connection) {
        try {
            Lsn maxLsn = connection.getMaxLsn();
            return new LsnOffset(maxLsn, maxLsn, null);
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public static String buildSplitScanQuery(TableId tableId, RowType pkRowType, boolean isFirstSplit, boolean isLastSplit) {
        return Db2Utils.buildSplitQuery(tableId, pkRowType, isFirstSplit, isLastSplit, -1, true);
    }

    public static PreparedStatement readTableSplitDataStatement(JdbcConnection jdbc, String sql, boolean isFirstSplit, boolean isLastSplit, Object[] splitStart, Object[] splitEnd, int primaryKeyNum, int fetchSize) {
        try {
            PreparedStatement statement = Db2Utils.initStatement(jdbc, sql, fetchSize);
            if (isFirstSplit && isLastSplit) {
                return statement;
            }
            if (isFirstSplit) {
                for (int i = 0; i < primaryKeyNum; ++i) {
                    statement.setObject(i + 1, splitEnd[i]);
                    statement.setObject(i + 1 + primaryKeyNum, splitEnd[i]);
                }
            } else if (isLastSplit) {
                for (int i = 0; i < primaryKeyNum; ++i) {
                    statement.setObject(i + 1, splitStart[i]);
                }
            } else {
                for (int i = 0; i < primaryKeyNum; ++i) {
                    statement.setObject(i + 1, splitStart[i]);
                    statement.setObject(i + 1 + primaryKeyNum, splitEnd[i]);
                    statement.setObject(i + 1 + 2 * primaryKeyNum, splitEnd[i]);
                }
            }
            return statement;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build the split data read statement.", e);
        }
    }

    public static Db2DatabaseSchema createDb2DatabaseSchema(Db2ConnectorConfig connectorConfig, Db2Connection connection) {
        TopicSelector<TableId> topicSelector = Db2TopicSelector.defaultSelector(connectorConfig);
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create();
        return new Db2DatabaseSchema(connectorConfig, schemaNameAdjuster, topicSelector, connection);
    }

    private static String getPrimaryKeyColumnsProjection(RowType pkRowType) {
        StringBuilder sql = new StringBuilder();
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            sql.append((String)fieldNamesIt.next());
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" , ");
        }
        return sql.toString();
    }

    private static String buildSplitQuery(TableId tableId, RowType pkRowType, boolean isFirstSplit, boolean isLastSplit, int limitSize, boolean isScanningData) {
        StringBuilder sql;
        String condition;
        if (isFirstSplit && isLastSplit) {
            condition = null;
        } else if (isFirstSplit) {
            sql = new StringBuilder();
            Db2Utils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " <= ?");
            if (isScanningData) {
                sql.append(" AND NOT (");
                Db2Utils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " = ?");
                sql.append(")");
            }
            condition = sql.toString();
        } else if (isLastSplit) {
            sql = new StringBuilder();
            Db2Utils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " >= ?");
            condition = sql.toString();
        } else {
            sql = new StringBuilder();
            Db2Utils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " >= ?");
            if (isScanningData) {
                sql.append(" AND NOT (");
                Db2Utils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " = ?");
                sql.append(")");
            }
            sql.append(" AND ");
            Db2Utils.addPrimaryKeyColumnsToCondition(pkRowType, sql, " <= ?");
            condition = sql.toString();
        }
        if (isScanningData) {
            return Db2Utils.buildSelectWithRowLimits(tableId, limitSize, "*", Optional.ofNullable(condition), Optional.empty());
        }
        String orderBy = pkRowType.getFieldNames().stream().collect(Collectors.joining(", "));
        return Db2Utils.buildSelectWithBoundaryRowLimits(tableId, limitSize, Db2Utils.getPrimaryKeyColumnsProjection(pkRowType), Db2Utils.getMaxPrimaryKeyColumnsProjection(pkRowType), Optional.ofNullable(condition), orderBy);
    }

    private static PreparedStatement initStatement(JdbcConnection jdbc, String sql, int fetchSize) throws SQLException {
        Connection connection = jdbc.connection();
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(fetchSize);
        return statement;
    }

    private static String getMaxPrimaryKeyColumnsProjection(RowType pkRowType) {
        StringBuilder sql = new StringBuilder();
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            sql.append("MAX(" + (String)fieldNamesIt.next() + ")");
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" , ");
        }
        return sql.toString();
    }

    private static String buildSelectWithRowLimits(TableId tableId, int limit, String projection, Optional<String> condition, Optional<String> orderBy) {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(projection).append(" FROM ");
        sql.append(Db2Utils.quoteSchemaAndTable(tableId));
        if (condition.isPresent()) {
            sql.append(" WHERE ").append(condition.get());
        }
        if (orderBy.isPresent()) {
            sql.append(" ORDER BY ").append(orderBy.get());
        }
        if (limit > 0) {
            sql.append(" FETCH FIRST ").append(limit).append(" ROWS ONLY ");
        }
        return sql.toString();
    }

    private static String quoteSchemaAndTable(TableId tableId) {
        StringBuilder quoted = new StringBuilder();
        if (tableId.schema() != null && !tableId.schema().isEmpty()) {
            quoted.append(Db2Utils.quote(tableId.schema())).append(".");
        }
        quoted.append(Db2Utils.quote(tableId.table()));
        return quoted.toString();
    }

    public static String quote(String dbOrTableName) {
        return "\"" + dbOrTableName + "\"";
    }

    public static String quote(TableId tableId) {
        return "\"" + tableId.schema() + "\".\"" + tableId.table() + "\"";
    }

    private static void addPrimaryKeyColumnsToCondition(RowType pkRowType, StringBuilder sql, String predicate) {
        Iterator fieldNamesIt = pkRowType.getFieldNames().iterator();
        while (fieldNamesIt.hasNext()) {
            sql.append((String)fieldNamesIt.next()).append(predicate);
            if (!fieldNamesIt.hasNext()) continue;
            sql.append(" AND ");
        }
    }

    private static String buildSelectWithBoundaryRowLimits(TableId tableId, int limit, String projection, String maxColumnProjection, Optional<String> condition, String orderBy) {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(maxColumnProjection);
        sql.append(" FROM (");
        sql.append("SELECT ");
        sql.append(projection);
        sql.append(" FROM ");
        sql.append(Db2Utils.quoteSchemaAndTable(tableId));
        if (condition.isPresent()) {
            sql.append(" WHERE ").append(condition.get());
        }
        sql.append(" ORDER BY ").append(orderBy);
        sql.append("FETCH FIRST ").append(limit).append(" ROWS ONLY ");
        sql.append(") T");
        return sql.toString();
    }
}

