/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.common.event.AddColumnEvent;
import org.apache.flink.cdc.common.event.AlterColumnTypeEvent;
import org.apache.flink.cdc.common.event.CreateTableEvent;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.event.DropColumnEvent;
import org.apache.flink.cdc.common.event.RenameColumnEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.SchemaChangeEventTypeFamily;
import org.apache.flink.cdc.common.event.TableId;

public class ChangeEventUtils {
    public static DataChangeEvent recreateDataChangeEvent(DataChangeEvent dataChangeEvent, TableId tableId) {
        switch (dataChangeEvent.op()) {
            case INSERT: {
                return DataChangeEvent.insertEvent(tableId, dataChangeEvent.after(), dataChangeEvent.meta());
            }
            case UPDATE: {
                return DataChangeEvent.updateEvent(tableId, dataChangeEvent.before(), dataChangeEvent.after(), dataChangeEvent.meta());
            }
            case REPLACE: {
                return DataChangeEvent.replaceEvent(tableId, dataChangeEvent.after(), dataChangeEvent.meta());
            }
            case DELETE: {
                return DataChangeEvent.deleteEvent(tableId, dataChangeEvent.before(), dataChangeEvent.meta());
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported operation type \"%s\" in data change event", new Object[]{dataChangeEvent.op()}));
    }

    public static SchemaChangeEvent recreateSchemaChangeEvent(SchemaChangeEvent schemaChangeEvent, TableId tableId) {
        if (schemaChangeEvent instanceof CreateTableEvent) {
            CreateTableEvent createTableEvent = (CreateTableEvent)schemaChangeEvent;
            return new CreateTableEvent(tableId, createTableEvent.getSchema());
        }
        if (schemaChangeEvent instanceof AlterColumnTypeEvent) {
            AlterColumnTypeEvent alterColumnTypeEvent = (AlterColumnTypeEvent)schemaChangeEvent;
            return new AlterColumnTypeEvent(tableId, alterColumnTypeEvent.getTypeMapping());
        }
        if (schemaChangeEvent instanceof RenameColumnEvent) {
            RenameColumnEvent renameColumnEvent = (RenameColumnEvent)schemaChangeEvent;
            return new RenameColumnEvent(tableId, renameColumnEvent.getNameMapping());
        }
        if (schemaChangeEvent instanceof DropColumnEvent) {
            DropColumnEvent dropColumnEvent = (DropColumnEvent)schemaChangeEvent;
            return new DropColumnEvent(tableId, dropColumnEvent.getDroppedColumnNames());
        }
        if (schemaChangeEvent instanceof AddColumnEvent) {
            AddColumnEvent addColumnEvent = (AddColumnEvent)schemaChangeEvent;
            return new AddColumnEvent(tableId, addColumnEvent.getAddedColumns());
        }
        throw new UnsupportedOperationException(String.format("Unsupported schema change event with type \"%s\"", schemaChangeEvent.getClass().getCanonicalName()));
    }

    public static Set<SchemaChangeEventType> resolveSchemaEvolutionOptions(List<String> includedSchemaEvolutionTypes, List<String> excludedSchemaEvolutionTypes) {
        ArrayList<SchemaChangeEventType> resultTypes = new ArrayList<SchemaChangeEventType>();
        for (String includeTag : includedSchemaEvolutionTypes) {
            resultTypes.addAll(ChangeEventUtils.resolveSchemaEvolutionTag(includeTag));
        }
        for (String excludeTag : excludedSchemaEvolutionTypes) {
            resultTypes.removeAll(ChangeEventUtils.resolveSchemaEvolutionTag(excludeTag));
        }
        return new HashSet<SchemaChangeEventType>(resultTypes);
    }

    @VisibleForTesting
    public static List<SchemaChangeEventType> resolveSchemaEvolutionTag(String tag) {
        SchemaChangeEventType type;
        ArrayList<SchemaChangeEventType> types = new ArrayList<SchemaChangeEventType>(Arrays.asList(SchemaChangeEventTypeFamily.ofTag(tag)));
        if (types.isEmpty() && (type = SchemaChangeEventType.ofTag(tag)) != null) {
            types.add(type);
        }
        return types;
    }
}

