/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.flink.annotation.Internal;
import org.apache.flink.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.avro.shaded.org.apache.avro.reflect.Nullable;

@Internal
final class SerializableAvroSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private transient Schema schema;

    SerializableAvroSchema() {
    }

    SerializableAvroSchema(Schema schema) {
        this.schema = schema;
    }

    Schema getAvroSchema() {
        return this.schema;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.schema == null) {
            oos.writeBoolean(false);
        } else {
            oos.writeBoolean(true);
            byte[] schemaStrInBytes = this.schema.toString(false).getBytes(StandardCharsets.UTF_8);
            oos.writeInt(schemaStrInBytes.length);
            oos.write(schemaStrInBytes);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        if (ois.readBoolean()) {
            int len = ois.readInt();
            byte[] content = new byte[len];
            ois.readFully(content);
            this.schema = new Schema.Parser().parse(new String(content, StandardCharsets.UTF_8));
        } else {
            this.schema = null;
        }
    }
}

