/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Function;
import org.apache.flink.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.avro.shaded.org.apache.avro.file.DataFileWriter;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericDatumWriter;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericRecord;
import org.apache.flink.avro.shaded.org.apache.avro.io.DatumWriter;
import org.apache.flink.avro.shaded.org.apache.avro.reflect.ReflectData;
import org.apache.flink.avro.shaded.org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.flink.avro.shaded.org.apache.avro.specific.SpecificData;
import org.apache.flink.avro.shaded.org.apache.avro.specific.SpecificDatumWriter;
import org.apache.flink.avro.shaded.org.apache.avro.specific.SpecificRecordBase;
import org.apache.flink.formats.avro.AvroBuilder;
import org.apache.flink.formats.avro.AvroWriterFactory;

public class AvroWriters {
    public static <T extends SpecificRecordBase> AvroWriterFactory<T> forSpecificRecord(Class<T> type) {
        String schemaString = SpecificData.get().getSchema(type).toString();
        AvroBuilder builder = out -> AvroWriters.createAvroDataFileWriter(schemaString, SpecificDatumWriter::new, out);
        return new AvroWriterFactory(builder);
    }

    public static AvroWriterFactory<GenericRecord> forGenericRecord(Schema schema) {
        final String schemaString = schema.toString();
        AvroBuilder<GenericRecord> builder = new AvroBuilder<GenericRecord>(){

            @Override
            public DataFileWriter<GenericRecord> createWriter(OutputStream outputStream) throws IOException {
                return AvroWriters.createAvroDataFileWriter(schemaString, new Function<Schema, DatumWriter<GenericRecord>>(){

                    @Override
                    public DatumWriter<GenericRecord> apply(Schema schema) {
                        return new GenericDatumWriter<GenericRecord>(schema);
                    }
                }, outputStream);
            }
        };
        return new AvroWriterFactory<GenericRecord>(builder);
    }

    public static <T> AvroWriterFactory<T> forReflectRecord(Class<T> type) {
        String schemaString = ReflectData.get().getSchema(type).toString();
        AvroBuilder builder = out -> AvroWriters.createAvroDataFileWriter(schemaString, ReflectDatumWriter::new, out);
        return new AvroWriterFactory(builder);
    }

    private static <T> DataFileWriter<T> createAvroDataFileWriter(String schemaString, Function<Schema, DatumWriter<T>> datumWriterFactory, OutputStream out) throws IOException {
        Schema schema = new Schema.Parser().parse(schemaString);
        DatumWriter<T> datumWriter = datumWriterFactory.apply(schema);
        DataFileWriter<T> dataFileWriter = new DataFileWriter<T>(datumWriter);
        dataFileWriter.create(schema, out);
        return dataFileWriter;
    }

    private AvroWriters() {
    }
}

