/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.security.scram;

import java.util.Collections;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.spi.LoginModule;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.security.scram.internals.ScramSaslClientProvider;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.security.scram.internals.ScramSaslServerProvider;

public class ScramLoginModule
implements LoginModule {
    private static final String USERNAME_CONFIG = "username";
    private static final String PASSWORD_CONFIG = "password";
    public static final String TOKEN_AUTH_CONFIG = "tokenauth";

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        Boolean useTokenAuthentication;
        String password;
        String username = (String)options.get(USERNAME_CONFIG);
        if (username != null) {
            subject.getPublicCredentials().add(username);
        }
        if ((password = (String)options.get(PASSWORD_CONFIG)) != null) {
            subject.getPrivateCredentials().add(password);
        }
        if ((useTokenAuthentication = Boolean.valueOf("true".equalsIgnoreCase((String)options.get(TOKEN_AUTH_CONFIG)))).booleanValue()) {
            Map<String, String> scramExtensions = Collections.singletonMap(TOKEN_AUTH_CONFIG, "true");
            subject.getPublicCredentials().add(scramExtensions);
        }
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public boolean logout() {
        return true;
    }

    @Override
    public boolean commit() {
        return true;
    }

    @Override
    public boolean abort() {
        return false;
    }

    static {
        ScramSaslClientProvider.initialize();
        ScramSaslServerProvider.initialize();
    }
}

