/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.ParsedSchema;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.ParsedSchemaHolder;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.SchemaValidationStrategy;
import org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.SchemaValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaValidatorBuilder {
    private static final Logger log = LoggerFactory.getLogger(SchemaValidatorBuilder.class);
    private SchemaValidationStrategy strategy;
    private static final String NEW_PREFIX = "new";
    private static final String OLD_PREFIX = "old";
    private static int MAX_SCHEMA_SIZE_FOR_LOGGING = 10240;
    private static String DIFFERENT_SCHEMA_TYPE = "Incompatible because of different schema type";

    public SchemaValidatorBuilder canReadStrategy() {
        this.strategy = (toValidate, existing) -> this.formatErrorMessages(toValidate.isBackwardCompatible(existing), existing, NEW_PREFIX, OLD_PREFIX, true);
        return this;
    }

    public SchemaValidatorBuilder canBeReadStrategy() {
        this.strategy = (toValidate, existing) -> this.formatErrorMessages(existing.isBackwardCompatible(toValidate), existing, OLD_PREFIX, NEW_PREFIX, true);
        return this;
    }

    public SchemaValidatorBuilder mutualReadStrategy() {
        this.strategy = (toValidate, existing) -> {
            List<String> result = this.formatErrorMessages(existing.isBackwardCompatible(toValidate), existing, OLD_PREFIX, NEW_PREFIX, false);
            result.addAll(this.formatErrorMessages(toValidate.isBackwardCompatible(existing), existing, NEW_PREFIX, OLD_PREFIX, true));
            return result;
        };
        return this;
    }

    public SchemaValidator validateLatest() {
        this.valid();
        return (toValidate, schemasInOrder) -> {
            Iterator schemas = schemasInOrder.iterator();
            if (schemas.hasNext()) {
                ParsedSchemaHolder existing = (ParsedSchemaHolder)schemas.next();
                ParsedSchema existingSchema = existing.schema();
                List<String> errorMessages = toValidate.schemaType().equals(existingSchema.schemaType()) ? this.strategy.validate(toValidate, existingSchema) : Lists.newArrayList(DIFFERENT_SCHEMA_TYPE);
                existing.clear();
                return errorMessages;
            }
            return new ArrayList();
        };
    }

    public SchemaValidator validateAll() {
        this.valid();
        return (toValidate, schemasInOrder) -> {
            for (ParsedSchemaHolder existing : schemasInOrder) {
                ParsedSchema existingSchema = existing.schema();
                List<String> errorMessages = toValidate.schemaType().equals(existingSchema.schemaType()) ? this.strategy.validate(toValidate, existingSchema) : Lists.newArrayList(DIFFERENT_SCHEMA_TYPE);
                existing.clear();
                if (errorMessages.isEmpty()) continue;
                return errorMessages;
            }
            return new ArrayList();
        };
    }

    private void valid() {
        if (null == this.strategy) {
            throw new RuntimeException("SchemaValidationStrategy not specified in builder");
        }
    }

    private List<String> formatErrorMessages(List<String> messages, ParsedSchema existing, String reader, String writer, boolean appendSchema) {
        if (messages.size() > 0) {
            try {
                messages.replaceAll(e -> String.format(e, reader, writer));
                if (appendSchema) {
                    if (existing.version() != null) {
                        messages.add("{oldSchemaVersion: " + existing.version() + "}");
                    }
                    if (existing.toString().length() <= MAX_SCHEMA_SIZE_FOR_LOGGING) {
                        messages.add("{oldSchema: '" + existing + "'}");
                    } else {
                        messages.add("{oldSchema: <truncated> '" + existing.toString().substring(0, MAX_SCHEMA_SIZE_FOR_LOGGING) + "...'}");
                    }
                }
            }
            catch (UnsupportedOperationException e2) {
                log.warn("Failed to append schema and version to error messages");
            }
        }
        return messages;
    }
}

