/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericData;
import org.apache.flink.avro.shaded.org.apache.avro.util.Utf8;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.CollectionUtil;

@Internal
public class RowDataToAvroConverters {
    public static RowDataToAvroConverter createConverter(LogicalType type) {
        RowDataToAvroConverter converter;
        switch (type.getTypeRoot()) {
            case NULL: {
                converter = new RowDataToAvroConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Schema schema, Object object) {
                        return null;
                    }
                };
                break;
            }
            case TINYINT: {
                converter = new RowDataToAvroConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Schema schema, Object object) {
                        return ((Byte)object).intValue();
                    }
                };
                break;
            }
            case SMALLINT: {
                converter = new RowDataToAvroConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Schema schema, Object object) {
                        return ((Short)object).intValue();
                    }
                };
                break;
            }
            case BOOLEAN: 
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: 
            case BIGINT: 
            case INTERVAL_DAY_TIME: 
            case FLOAT: 
            case DOUBLE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: {
                converter = new RowDataToAvroConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Schema schema, Object object) {
                        return object;
                    }
                };
                break;
            }
            case CHAR: 
            case VARCHAR: {
                converter = new RowDataToAvroConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Schema schema, Object object) {
                        return new Utf8(object.toString());
                    }
                };
                break;
            }
            case BINARY: 
            case VARBINARY: {
                converter = new RowDataToAvroConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Schema schema, Object object) {
                        return ByteBuffer.wrap((byte[])object);
                    }
                };
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                converter = new RowDataToAvroConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Schema schema, Object object) {
                        return ((TimestampData)object).toInstant().toEpochMilli();
                    }
                };
                break;
            }
            case DECIMAL: {
                converter = new RowDataToAvroConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Schema schema, Object object) {
                        return ByteBuffer.wrap(((DecimalData)object).toUnscaledBytes());
                    }
                };
                break;
            }
            case ARRAY: {
                converter = RowDataToAvroConverters.createArrayConverter((ArrayType)type);
                break;
            }
            case ROW: {
                converter = RowDataToAvroConverters.createRowConverter((RowType)type);
                break;
            }
            case MAP: 
            case MULTISET: {
                converter = RowDataToAvroConverters.createMapConverter(type);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + type);
            }
        }
        return new RowDataToAvroConverter(){
            private static final long serialVersionUID = 1L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object convert(Schema schema, Object object) {
                Schema actualSchema;
                if (object == null) {
                    return null;
                }
                if (schema.getType() == Schema.Type.UNION) {
                    List<Schema> types = schema.getTypes();
                    int size = types.size();
                    if (size == 2 && types.get(1).getType() == Schema.Type.NULL) {
                        actualSchema = types.get(0);
                        return converter.convert(actualSchema, object);
                    } else {
                        if (size != 2 || types.get(0).getType() != Schema.Type.NULL) throw new IllegalArgumentException("The Avro schema is not a nullable type: " + schema.toString());
                        actualSchema = types.get(1);
                    }
                    return converter.convert(actualSchema, object);
                } else {
                    actualSchema = schema;
                }
                return converter.convert(actualSchema, object);
            }
        };
    }

    private static RowDataToAvroConverter createRowConverter(RowType rowType) {
        final RowDataToAvroConverter[] fieldConverters = (RowDataToAvroConverter[])rowType.getChildren().stream().map(RowDataToAvroConverters::createConverter).toArray(RowDataToAvroConverter[]::new);
        LogicalType[] fieldTypes = (LogicalType[])rowType.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        final RowData.FieldGetter[] fieldGetters = new RowData.FieldGetter[fieldTypes.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            fieldGetters[i] = RowData.createFieldGetter((LogicalType)fieldTypes[i], (int)i);
        }
        final int length = rowType.getFieldCount();
        return new RowDataToAvroConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Schema schema, Object object) {
                RowData row = (RowData)object;
                List<Schema.Field> fields = schema.getFields();
                GenericData.Record record = new GenericData.Record(schema);
                for (int i = 0; i < length; ++i) {
                    Schema.Field schemaField = fields.get(i);
                    try {
                        Object avroObject = fieldConverters[i].convert(schemaField.schema(), fieldGetters[i].getFieldOrNull(row));
                        record.put(i, avroObject);
                        continue;
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(String.format("Fail to serialize at field: %s.", schemaField.name()), t);
                    }
                }
                return record;
            }
        };
    }

    private static RowDataToAvroConverter createArrayConverter(ArrayType arrayType) {
        LogicalType elementType = arrayType.getElementType();
        final ArrayData.ElementGetter elementGetter = ArrayData.createElementGetter((LogicalType)elementType);
        final RowDataToAvroConverter elementConverter = RowDataToAvroConverters.createConverter(arrayType.getElementType());
        return new RowDataToAvroConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Schema schema, Object object) {
                Schema elementSchema = schema.getElementType();
                ArrayData arrayData = (ArrayData)object;
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < arrayData.size(); ++i) {
                    list.add(elementConverter.convert(elementSchema, elementGetter.getElementOrNull(arrayData, i)));
                }
                return list;
            }
        };
    }

    private static RowDataToAvroConverter createMapConverter(LogicalType type) {
        LogicalType valueType = AvroSchemaConverter.extractValueTypeToAvroMap(type);
        final ArrayData.ElementGetter valueGetter = ArrayData.createElementGetter((LogicalType)valueType);
        final RowDataToAvroConverter valueConverter = RowDataToAvroConverters.createConverter(valueType);
        return new RowDataToAvroConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Schema schema, Object object) {
                Schema valueSchema = schema.getValueType();
                MapData mapData = (MapData)object;
                ArrayData keyArray = mapData.keyArray();
                ArrayData valueArray = mapData.valueArray();
                HashMap map = CollectionUtil.newHashMapWithExpectedSize((int)mapData.size());
                for (int i = 0; i < mapData.size(); ++i) {
                    String key = keyArray.getString(i).toString();
                    Object value = valueConverter.convert(valueSchema, valueGetter.getElementOrNull(valueArray, i));
                    map.put(key, value);
                }
                return map;
            }
        };
    }

    @FunctionalInterface
    public static interface RowDataToAvroConverter
    extends Serializable {
        public Object convert(Schema var1, Object var2);
    }
}

