/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.io.confluent.kafka.schemaregistry.client.rest;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class UriBuilder {
    private final String templatePath;
    private StringBuilder queryParamString = new StringBuilder();
    private final List<String> templateNames;

    public UriBuilder(String templatePath) {
        this.templatePath = Objects.requireNonNull(templatePath);
        this.templateNames = UriBuilder.findNamesInTemplate(templatePath);
    }

    public static UriBuilder fromPath(String path) {
        return new UriBuilder(path);
    }

    public URI build(Object ... templatePathValues) {
        List templateValues = Arrays.asList(templatePathValues).stream().map(o -> UriPercentEncoder.encode(String.valueOf(o), Charset.defaultCharset())).collect(Collectors.toList());
        if (templateValues.size() != this.templateNames.size()) {
            throw new IllegalArgumentException("Mismatched number of template variable names: expected " + this.templateNames.size() + ", got " + templateValues.size());
        }
        String encodedPath = this.templatePath;
        for (int i = 0; i < this.templateNames.size(); ++i) {
            encodedPath = encodedPath.replace(this.templateNames.get(i), (CharSequence)templateValues.get(i));
        }
        if (this.queryParamString.length() > 0) {
            if (encodedPath.indexOf(63) < 0) {
                encodedPath = encodedPath + '?';
            }
            encodedPath = encodedPath + this.queryParamString;
        }
        try {
            return new URI(encodedPath);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public UriBuilder queryParam(String paramName, String paramValue) {
        if (this.queryParamString.length() > 0) {
            this.queryParamString.append('&');
        }
        try {
            this.queryParamString.append(UriBuilder.encodeQueryParameter(paramName)).append('=').append(UriBuilder.encodeQueryParameter(paramValue));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public UriBuilder queryParam(String paramName, Integer paramValue) {
        this.queryParam(paramName, String.valueOf(paramValue));
        return this;
    }

    public UriBuilder queryParam(String paramName, boolean paramValue) {
        this.queryParam(paramName, Boolean.toString(paramValue));
        return this;
    }

    public String toString() {
        return this.templatePath;
    }

    static String encodeQueryParameter(String paramValue) throws UnsupportedEncodingException {
        return URLEncoder.encode(paramValue, "UTF-8").replace("+", "%20");
    }

    static final List<String> findNamesInTemplate(String path) {
        int counter = 0;
        ArrayList<String> templateNames = new ArrayList<String>();
        StringBuilder sb = null;
        while (counter < path.length()) {
            char c;
            if ((c = path.charAt(counter++)) == '{' && sb == null) {
                sb = new StringBuilder();
            }
            if (sb != null) {
                sb.append(c);
            }
            if (c != '}' || sb == null) continue;
            templateNames.add(sb.toString());
            sb = null;
        }
        return Collections.unmodifiableList(templateNames);
    }

    static class UriPercentEncoder {
        static final String CHARS_UNENCODE;
        private static final BitSet UNENCODE;

        UriPercentEncoder() {
        }

        static String encode(String value, Charset charset) {
            StringBuilder sb = new StringBuilder(value.length() * 2);
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (UNENCODE.get(c & 0xFF)) {
                    sb.append(c);
                    continue;
                }
                String hex = Integer.toHexString(c).toUpperCase();
                if (hex.length() == 1) {
                    sb.append("%0").append(hex);
                    continue;
                }
                sb.append('%').append(hex);
            }
            return sb.toString();
        }

        static {
            String gendelims = "@:";
            String subdelims = "!$&'()*+,;=";
            String alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
            String unreserved = "-._~";
            CHARS_UNENCODE = alpha + unreserved + gendelims + subdelims;
            BitSet unencode = new BitSet(256);
            for (int i = 0; i < CHARS_UNENCODE.length(); ++i) {
                unencode.set(CHARS_UNENCODE.charAt(i));
            }
            UNENCODE = unencode;
        }
    }
}

