/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.requests.RequestUtils;

public class OffsetFetchResponse
extends AbstractResponse {
    public static final long INVALID_OFFSET = -1L;
    public static final String NO_METADATA = "";
    public static final PartitionData UNKNOWN_PARTITION = new PartitionData(-1L, Optional.empty(), "", Errors.UNKNOWN_TOPIC_OR_PARTITION);
    public static final PartitionData UNAUTHORIZED_PARTITION = new PartitionData(-1L, Optional.empty(), "", Errors.TOPIC_AUTHORIZATION_FAILED);
    private static final List<Errors> PARTITION_ERRORS = Arrays.asList(Errors.UNKNOWN_TOPIC_OR_PARTITION, Errors.TOPIC_AUTHORIZATION_FAILED);
    private final OffsetFetchResponseData data;
    private final Errors error;

    public OffsetFetchResponse(Errors error, Map<TopicPartition, PartitionData> responseData) {
        this(0, error, responseData);
    }

    public OffsetFetchResponse(int throttleTimeMs, Errors error, Map<TopicPartition, PartitionData> responseData) {
        super(ApiKeys.OFFSET_FETCH);
        HashMap<String, OffsetFetchResponseData.OffsetFetchResponseTopic> offsetFetchResponseTopicMap = new HashMap<String, OffsetFetchResponseData.OffsetFetchResponseTopic>();
        for (Map.Entry<TopicPartition, PartitionData> entry : responseData.entrySet()) {
            String topicName = entry.getKey().topic();
            OffsetFetchResponseData.OffsetFetchResponseTopic topic = offsetFetchResponseTopicMap.getOrDefault(topicName, new OffsetFetchResponseData.OffsetFetchResponseTopic().setName(topicName));
            PartitionData partitionData = entry.getValue();
            topic.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(entry.getKey().partition()).setErrorCode(partitionData.error.code()).setCommittedOffset(partitionData.offset).setCommittedLeaderEpoch(partitionData.leaderEpoch.orElse(-1)).setMetadata(partitionData.metadata));
            offsetFetchResponseTopicMap.put(topicName, topic);
        }
        this.data = new OffsetFetchResponseData().setTopics(new ArrayList<OffsetFetchResponseData.OffsetFetchResponseTopic>(offsetFetchResponseTopicMap.values())).setErrorCode(error.code()).setThrottleTimeMs(throttleTimeMs);
        this.error = error;
    }

    public OffsetFetchResponse(OffsetFetchResponseData data, short version) {
        super(ApiKeys.OFFSET_FETCH);
        this.data = data;
        this.error = version >= 2 ? Errors.forCode(data.errorCode()) : OffsetFetchResponse.topLevelError(data);
    }

    private static Errors topLevelError(OffsetFetchResponseData data) {
        for (OffsetFetchResponseData.OffsetFetchResponseTopic topic : data.topics()) {
            for (OffsetFetchResponseData.OffsetFetchResponsePartition partition : topic.partitions()) {
                Errors partitionError = Errors.forCode(partition.errorCode());
                if (partitionError == Errors.NONE || PARTITION_ERRORS.contains((Object)partitionError)) continue;
                return partitionError;
            }
        }
        return Errors.NONE;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public boolean hasError() {
        return this.error != Errors.NONE;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.updateErrorCounts(counts, this.error);
        this.data.topics().forEach(topic -> topic.partitions().forEach(partition -> this.updateErrorCounts(counts, Errors.forCode(partition.errorCode()))));
        return counts;
    }

    public Map<TopicPartition, PartitionData> responseData() {
        HashMap<TopicPartition, PartitionData> responseData = new HashMap<TopicPartition, PartitionData>();
        for (OffsetFetchResponseData.OffsetFetchResponseTopic topic : this.data.topics()) {
            for (OffsetFetchResponseData.OffsetFetchResponsePartition partition : topic.partitions()) {
                responseData.put(new TopicPartition(topic.name(), partition.partitionIndex()), new PartitionData(partition.committedOffset(), RequestUtils.getLeaderEpoch(partition.committedLeaderEpoch()), partition.metadata(), Errors.forCode(partition.errorCode())));
            }
        }
        return responseData;
    }

    public static OffsetFetchResponse parse(ByteBuffer buffer, short version) {
        return new OffsetFetchResponse(new OffsetFetchResponseData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public OffsetFetchResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 4;
    }

    public static final class PartitionData {
        public final long offset;
        public final String metadata;
        public final Errors error;
        public final Optional<Integer> leaderEpoch;

        public PartitionData(long offset, Optional<Integer> leaderEpoch, String metadata, Errors error) {
            this.offset = offset;
            this.leaderEpoch = leaderEpoch;
            this.metadata = metadata;
            this.error = error;
        }

        public boolean hasError() {
            return this.error != Errors.NONE;
        }

        public boolean equals(Object other) {
            if (!(other instanceof PartitionData)) {
                return false;
            }
            PartitionData otherPartition = (PartitionData)other;
            return Objects.equals(this.offset, otherPartition.offset) && Objects.equals(this.leaderEpoch, otherPartition.leaderEpoch) && Objects.equals(this.metadata, otherPartition.metadata) && Objects.equals((Object)this.error, (Object)otherPartition.error);
        }

        public String toString() {
            return "PartitionData(offset=" + this.offset + ", leaderEpoch=" + this.leaderEpoch.orElse(-1) + ", metadata=" + this.metadata + ", error='" + this.error.toString() + ")";
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.offset, this.leaderEpoch, this.metadata, this.error});
        }
    }
}

