/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class OffsetDeleteResponseData
implements ApiMessage {
    short errorCode;
    int throttleTimeMs;
    OffsetDeleteResponseTopicCollection topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(OffsetDeleteResponseTopic.SCHEMA_0), "The responses for each topic."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public OffsetDeleteResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public OffsetDeleteResponseData() {
        this.errorCode = 0;
        this.throttleTimeMs = 0;
        this.topics = new OffsetDeleteResponseTopicCollection(0);
    }

    @Override
    public short apiKey() {
        return 47;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.errorCode = _readable.readShort();
        this.throttleTimeMs = _readable.readInt();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        OffsetDeleteResponseTopicCollection newCollection = new OffsetDeleteResponseTopicCollection(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new OffsetDeleteResponseTopic(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeInt(this.topics.size());
        for (OffsetDeleteResponseTopic topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(2);
        _size.addBytes(4);
        _size.addBytes(4);
        for (OffsetDeleteResponseTopic topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetDeleteResponseData)) {
            return false;
        }
        OffsetDeleteResponseData other = (OffsetDeleteResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public OffsetDeleteResponseData duplicate() {
        OffsetDeleteResponseData _duplicate = new OffsetDeleteResponseData();
        _duplicate.errorCode = this.errorCode;
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        OffsetDeleteResponseTopicCollection newTopics = new OffsetDeleteResponseTopicCollection(this.topics.size());
        for (OffsetDeleteResponseTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "OffsetDeleteResponseData(errorCode=" + this.errorCode + ", throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public OffsetDeleteResponseTopicCollection topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public OffsetDeleteResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public OffsetDeleteResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public OffsetDeleteResponseData setTopics(OffsetDeleteResponseTopicCollection v) {
        this.topics = v;
        return this;
    }

    public static class OffsetDeleteResponseTopicCollection
    extends ImplicitLinkedHashMultiCollection<OffsetDeleteResponseTopic> {
        public OffsetDeleteResponseTopicCollection() {
        }

        public OffsetDeleteResponseTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public OffsetDeleteResponseTopicCollection(Iterator<OffsetDeleteResponseTopic> iterator) {
            super(iterator);
        }

        @Override
        public OffsetDeleteResponseTopic find(String name) {
            OffsetDeleteResponseTopic _key = new OffsetDeleteResponseTopic();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<OffsetDeleteResponseTopic> findAll(String name) {
            OffsetDeleteResponseTopic _key = new OffsetDeleteResponseTopic();
            _key.setName(name);
            return this.findAll(_key);
        }

        public OffsetDeleteResponseTopicCollection duplicate() {
            OffsetDeleteResponseTopicCollection _duplicate = new OffsetDeleteResponseTopicCollection(this.size());
            for (OffsetDeleteResponseTopic _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class OffsetDeleteResponsePartitionCollection
    extends ImplicitLinkedHashMultiCollection<OffsetDeleteResponsePartition> {
        public OffsetDeleteResponsePartitionCollection() {
        }

        public OffsetDeleteResponsePartitionCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public OffsetDeleteResponsePartitionCollection(Iterator<OffsetDeleteResponsePartition> iterator) {
            super(iterator);
        }

        @Override
        public OffsetDeleteResponsePartition find(int partitionIndex) {
            OffsetDeleteResponsePartition _key = new OffsetDeleteResponsePartition();
            _key.setPartitionIndex(partitionIndex);
            return this.find(_key);
        }

        @Override
        public List<OffsetDeleteResponsePartition> findAll(int partitionIndex) {
            OffsetDeleteResponsePartition _key = new OffsetDeleteResponsePartition();
            _key.setPartitionIndex(partitionIndex);
            return this.findAll(_key);
        }

        public OffsetDeleteResponsePartitionCollection duplicate() {
            OffsetDeleteResponsePartitionCollection _duplicate = new OffsetDeleteResponsePartitionCollection(this.size());
            for (OffsetDeleteResponsePartition _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class OffsetDeleteResponsePartition
    implements Message,
    ImplicitLinkedHashCollection.Element {
        int partitionIndex;
        short errorCode;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public OffsetDeleteResponsePartition(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public OffsetDeleteResponsePartition() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetDeleteResponsePartition");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OffsetDeleteResponsePartition");
            }
            _size.addBytes(4);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof OffsetDeleteResponsePartition)) {
                return false;
            }
            OffsetDeleteResponsePartition other = (OffsetDeleteResponsePartition)obj;
            return this.partitionIndex == other.partitionIndex;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetDeleteResponsePartition)) {
                return false;
            }
            OffsetDeleteResponsePartition other = (OffsetDeleteResponsePartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        @Override
        public OffsetDeleteResponsePartition duplicate() {
            OffsetDeleteResponsePartition _duplicate = new OffsetDeleteResponsePartition();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.errorCode = this.errorCode;
            return _duplicate;
        }

        public String toString() {
            return "OffsetDeleteResponsePartition(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetDeleteResponsePartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public OffsetDeleteResponsePartition setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class OffsetDeleteResponseTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        OffsetDeleteResponsePartitionCollection partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetDeleteResponsePartition.SCHEMA_0), "The responses for each partition in the topic."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public OffsetDeleteResponseTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public OffsetDeleteResponseTopic() {
            this.name = "";
            this.partitions = new OffsetDeleteResponsePartitionCollection(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetDeleteResponseTopic");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            OffsetDeleteResponsePartitionCollection newCollection = new OffsetDeleteResponsePartitionCollection(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new OffsetDeleteResponsePartition(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                OffsetDeleteResponsePartition partitionsElement = (OffsetDeleteResponsePartition)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OffsetDeleteResponseTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            _size.addBytes(4);
            for (OffsetDeleteResponsePartition partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof OffsetDeleteResponseTopic)) {
                return false;
            }
            OffsetDeleteResponseTopic other = (OffsetDeleteResponseTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetDeleteResponseTopic)) {
                return false;
            }
            OffsetDeleteResponseTopic other = (OffsetDeleteResponseTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public OffsetDeleteResponseTopic duplicate() {
            OffsetDeleteResponseTopic _duplicate = new OffsetDeleteResponseTopic();
            _duplicate.name = this.name;
            OffsetDeleteResponsePartitionCollection newPartitions = new OffsetDeleteResponsePartitionCollection(this.partitions.size());
            for (OffsetDeleteResponsePartition _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "OffsetDeleteResponseTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public OffsetDeleteResponsePartitionCollection partitions() {
            return this.partitions;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetDeleteResponseTopic setName(String v) {
            this.name = v;
            return this;
        }

        public OffsetDeleteResponseTopic setPartitions(OffsetDeleteResponsePartitionCollection v) {
            this.partitions = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }
}

