/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.ByteUtils;

public class DescribeGroupsRequestData
implements ApiMessage {
    List<String> groups;
    boolean includeAuthorizedOperations;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 5;

    public DescribeGroupsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeGroupsRequestData() {
        this.groups = new ArrayList<String>(0);
        this.includeAuthorizedOperations = false;
    }

    @Override
    public short apiKey() {
        return 15;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int length;
        int i;
        ArrayList<String> newCollection;
        int arrayLength;
        if (_version >= 5) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field groups was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field groups element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field groups element had invalid length " + length);
                }
                newCollection.add(_readable.readString(length));
            }
            this.groups = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field groups was serialized as null");
            }
            newCollection = new ArrayList<String>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field groups element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field groups element had invalid length " + length);
                }
                newCollection.add(_readable.readString(length));
            }
            this.groups = newCollection;
        }
        this.includeAuthorizedOperations = _version >= 3 ? _readable.readByte() != 0 : false;
        this._unknownTaggedFields = null;
        if (_version >= 5) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 5) {
            _writable.writeUnsignedVarint(this.groups.size() + 1);
            for (String groupsElement : this.groups) {
                byte[] _stringBytes = _cache.getSerializedValue(groupsElement);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
        } else {
            _writable.writeInt(this.groups.size());
            for (String groupsElement : this.groups) {
                byte[] _stringBytes = _cache.getSerializedValue(groupsElement);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
        }
        if (_version >= 3) {
            _writable.writeByte(this.includeAuthorizedOperations ? (byte)1 : 0);
        } else if (this.includeAuthorizedOperations) {
            throw new UnsupportedVersionException("Attempted to write a non-default includeAuthorizedOperations at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 5) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 5) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.groups.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (String groupsElement : this.groups) {
            byte[] _stringBytes = groupsElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'groupsElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(groupsElement, _stringBytes);
            if (_version >= 5) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                continue;
            }
            _size.addBytes(_stringBytes.length + 2);
        }
        if (_version >= 3) {
            _size.addBytes(1);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 5) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeGroupsRequestData)) {
            return false;
        }
        DescribeGroupsRequestData other = (DescribeGroupsRequestData)obj;
        if (this.groups == null ? other.groups != null : !this.groups.equals(other.groups)) {
            return false;
        }
        if (this.includeAuthorizedOperations != other.includeAuthorizedOperations) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groups == null ? 0 : this.groups.hashCode());
        hashCode = 31 * hashCode + (this.includeAuthorizedOperations ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public DescribeGroupsRequestData duplicate() {
        DescribeGroupsRequestData _duplicate = new DescribeGroupsRequestData();
        ArrayList<String> newGroups = new ArrayList<String>(this.groups.size());
        for (String _element : this.groups) {
            newGroups.add(_element);
        }
        _duplicate.groups = newGroups;
        _duplicate.includeAuthorizedOperations = this.includeAuthorizedOperations;
        return _duplicate;
    }

    public String toString() {
        return "DescribeGroupsRequestData(groups=" + MessageUtil.deepToString(this.groups.iterator()) + ", includeAuthorizedOperations=" + (this.includeAuthorizedOperations ? "true" : "false") + ")";
    }

    public List<String> groups() {
        return this.groups;
    }

    public boolean includeAuthorizedOperations() {
        return this.includeAuthorizedOperations;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeGroupsRequestData setGroups(List<String> v) {
        this.groups = v;
        return this;
    }

    public DescribeGroupsRequestData setIncludeAuthorizedOperations(boolean v) {
        this.includeAuthorizedOperations = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("groups", new ArrayOf(Type.STRING), "The names of the groups to describe")));
        SCHEMA_4 = SCHEMA_3 = new Schema(new Field("groups", new ArrayOf(Type.STRING), "The names of the groups to describe"), new Field("include_authorized_operations", Type.BOOLEAN, "Whether to include authorized operations."));
        SCHEMA_5 = new Schema(new Field("groups", new CompactArrayOf(Type.COMPACT_STRING), "The names of the groups to describe"), new Field("include_authorized_operations", Type.BOOLEAN, "Whether to include authorized operations."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }
}

