/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.consumer.internals;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.ConsumerProtocolAssignment;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.message.ConsumerProtocolSubscription;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.utils.CollectionUtils;

public class ConsumerProtocol {
    public static final String PROTOCOL_TYPE = "consumer";

    public static short deserializeVersion(ByteBuffer buffer) {
        try {
            return buffer.getShort();
        }
        catch (BufferUnderflowException e) {
            throw new SchemaException("Buffer underflow while parsing consumer protocol's header", e);
        }
    }

    public static ByteBuffer serializeSubscription(ConsumerPartitionAssignor.Subscription subscription) {
        return ConsumerProtocol.serializeSubscription(subscription, (short)1);
    }

    public static ByteBuffer serializeSubscription(ConsumerPartitionAssignor.Subscription subscription, short version) {
        version = ConsumerProtocol.checkSubscriptionVersion(version);
        ConsumerProtocolSubscription data = new ConsumerProtocolSubscription();
        ArrayList<String> topics = new ArrayList<String>(subscription.topics());
        Collections.sort(topics);
        data.setTopics(topics);
        data.setUserData(subscription.userData() != null ? subscription.userData().duplicate() : null);
        ArrayList<TopicPartition> ownedPartitions = new ArrayList<TopicPartition>(subscription.ownedPartitions());
        ownedPartitions.sort(Comparator.comparing(TopicPartition::topic).thenComparing(TopicPartition::partition));
        ConsumerProtocolSubscription.TopicPartition partition = null;
        for (TopicPartition tp : ownedPartitions) {
            if (partition == null || !partition.topic().equals(tp.topic())) {
                partition = new ConsumerProtocolSubscription.TopicPartition().setTopic(tp.topic());
                data.ownedPartitions().add(partition);
            }
            partition.partitions().add(tp.partition());
        }
        return MessageUtil.toVersionPrefixedByteBuffer(version, data);
    }

    public static ConsumerPartitionAssignor.Subscription deserializeSubscription(ByteBuffer buffer, short version) {
        version = ConsumerProtocol.checkSubscriptionVersion(version);
        try {
            ConsumerProtocolSubscription data = new ConsumerProtocolSubscription(new ByteBufferAccessor(buffer), version);
            ArrayList<TopicPartition> ownedPartitions = new ArrayList<TopicPartition>();
            for (ConsumerProtocolSubscription.TopicPartition tp : data.ownedPartitions()) {
                for (Integer partition : tp.partitions()) {
                    ownedPartitions.add(new TopicPartition(tp.topic(), partition));
                }
            }
            return new ConsumerPartitionAssignor.Subscription(data.topics(), data.userData() != null ? data.userData().duplicate() : null, ownedPartitions);
        }
        catch (BufferUnderflowException e) {
            throw new SchemaException("Buffer underflow while parsing consumer protocol's subscription", e);
        }
    }

    public static ConsumerPartitionAssignor.Subscription deserializeSubscription(ByteBuffer buffer) {
        return ConsumerProtocol.deserializeSubscription(buffer, ConsumerProtocol.deserializeVersion(buffer));
    }

    public static ByteBuffer serializeAssignment(ConsumerPartitionAssignor.Assignment assignment) {
        return ConsumerProtocol.serializeAssignment(assignment, (short)1);
    }

    public static ByteBuffer serializeAssignment(ConsumerPartitionAssignor.Assignment assignment, short version) {
        version = ConsumerProtocol.checkAssignmentVersion(version);
        ConsumerProtocolAssignment data = new ConsumerProtocolAssignment();
        data.setUserData(assignment.userData() != null ? assignment.userData().duplicate() : null);
        Map<String, List<Integer>> partitionsByTopic = CollectionUtils.groupPartitionsByTopic(assignment.partitions());
        for (Map.Entry<String, List<Integer>> topicEntry : partitionsByTopic.entrySet()) {
            data.assignedPartitions().add(new ConsumerProtocolAssignment.TopicPartition().setTopic(topicEntry.getKey()).setPartitions(topicEntry.getValue()));
        }
        return MessageUtil.toVersionPrefixedByteBuffer(version, data);
    }

    public static ConsumerPartitionAssignor.Assignment deserializeAssignment(ByteBuffer buffer, short version) {
        version = ConsumerProtocol.checkAssignmentVersion(version);
        try {
            ConsumerProtocolAssignment data = new ConsumerProtocolAssignment(new ByteBufferAccessor(buffer), version);
            ArrayList<TopicPartition> assignedPartitions = new ArrayList<TopicPartition>();
            for (ConsumerProtocolAssignment.TopicPartition tp : data.assignedPartitions()) {
                for (Integer partition : tp.partitions()) {
                    assignedPartitions.add(new TopicPartition(tp.topic(), partition));
                }
            }
            return new ConsumerPartitionAssignor.Assignment(assignedPartitions, data.userData() != null ? data.userData().duplicate() : null);
        }
        catch (BufferUnderflowException e) {
            throw new SchemaException("Buffer underflow while parsing consumer protocol's assignment", e);
        }
    }

    public static ConsumerPartitionAssignor.Assignment deserializeAssignment(ByteBuffer buffer) {
        return ConsumerProtocol.deserializeAssignment(buffer, ConsumerProtocol.deserializeVersion(buffer));
    }

    private static short checkSubscriptionVersion(short version) {
        if (version < 0) {
            throw new SchemaException("Unsupported subscription version: " + version);
        }
        if (version > 1) {
            return 1;
        }
        return version;
    }

    private static short checkAssignmentVersion(short version) {
        if (version < 0) {
            throw new SchemaException("Unsupported assignment version: " + version);
        }
        if (version > 1) {
            return 1;
        }
        return version;
    }
}

