/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.consumer;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.Cluster;
import org.apache.flink.avro.registry.confluent.shaded.org.apache.kafka.common.TopicPartition;

public interface ConsumerPartitionAssignor {
    default public ByteBuffer subscriptionUserData(Set<String> topics) {
        return null;
    }

    public GroupAssignment assign(Cluster var1, GroupSubscription var2);

    default public void onAssignment(Assignment assignment, ConsumerGroupMetadata metadata) {
    }

    default public List<RebalanceProtocol> supportedProtocols() {
        return Collections.singletonList(RebalanceProtocol.EAGER);
    }

    default public short version() {
        return 0;
    }

    public String name();

    public static enum RebalanceProtocol {
        EAGER(0),
        COOPERATIVE(1);

        private final byte id;

        private RebalanceProtocol(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static RebalanceProtocol forId(byte id) {
            switch (id) {
                case 0: {
                    return EAGER;
                }
                case 1: {
                    return COOPERATIVE;
                }
            }
            throw new IllegalArgumentException("Unknown rebalance protocol id: " + id);
        }
    }

    public static final class GroupAssignment {
        private final Map<String, Assignment> assignments;

        public GroupAssignment(Map<String, Assignment> assignments) {
            this.assignments = assignments;
        }

        public Map<String, Assignment> groupAssignment() {
            return this.assignments;
        }
    }

    public static final class GroupSubscription {
        private final Map<String, Subscription> subscriptions;

        public GroupSubscription(Map<String, Subscription> subscriptions) {
            this.subscriptions = subscriptions;
        }

        public Map<String, Subscription> groupSubscription() {
            return this.subscriptions;
        }
    }

    public static final class Assignment {
        private List<TopicPartition> partitions;
        private ByteBuffer userData;

        public Assignment(List<TopicPartition> partitions, ByteBuffer userData) {
            this.partitions = partitions;
            this.userData = userData;
        }

        public Assignment(List<TopicPartition> partitions) {
            this(partitions, null);
        }

        public List<TopicPartition> partitions() {
            return this.partitions;
        }

        public ByteBuffer userData() {
            return this.userData;
        }

        public String toString() {
            return "Assignment(partitions=" + this.partitions + (this.userData == null ? "" : ", userDataSize=" + this.userData.remaining()) + ')';
        }
    }

    public static final class Subscription {
        private final List<String> topics;
        private final ByteBuffer userData;
        private final List<TopicPartition> ownedPartitions;
        private Optional<String> groupInstanceId;

        public Subscription(List<String> topics, ByteBuffer userData, List<TopicPartition> ownedPartitions) {
            this.topics = topics;
            this.userData = userData;
            this.ownedPartitions = ownedPartitions;
            this.groupInstanceId = Optional.empty();
        }

        public Subscription(List<String> topics, ByteBuffer userData) {
            this(topics, userData, Collections.emptyList());
        }

        public Subscription(List<String> topics) {
            this(topics, null, Collections.emptyList());
        }

        public List<String> topics() {
            return this.topics;
        }

        public ByteBuffer userData() {
            return this.userData;
        }

        public List<TopicPartition> ownedPartitions() {
            return this.ownedPartitions;
        }

        public void setGroupInstanceId(Optional<String> groupInstanceId) {
            this.groupInstanceId = groupInstanceId;
        }

        public Optional<String> groupInstanceId() {
            return this.groupInstanceId;
        }
    }
}

