/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.io.network.netty.SSLHandlerFactory;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;

public final class RestServerEndpointConfiguration {
    private final String restAddress;
    @Nullable
    private final String restBindAddress;
    private final int restBindPort;
    @Nullable
    private final SSLHandlerFactory sslHandlerFactory;
    private final Path uploadDir;
    private final int maxContentLength;
    private final Map<String, String> responseHeaders;

    private RestServerEndpointConfiguration(String restAddress, @Nullable String restBindAddress, int restBindPort, @Nullable SSLHandlerFactory sslHandlerFactory, Path uploadDir, int maxContentLength, Map<String, String> responseHeaders) {
        Preconditions.checkArgument((0 <= restBindPort && restBindPort < 65536 ? 1 : 0) != 0, (Object)("The bing rest port " + restBindPort + " is out of range (0, 65536["));
        Preconditions.checkArgument((maxContentLength > 0 ? 1 : 0) != 0, (String)"maxContentLength must be positive, was: %d", (Object[])new Object[]{maxContentLength});
        this.restAddress = Objects.requireNonNull(restAddress);
        this.restBindAddress = restBindAddress;
        this.restBindPort = restBindPort;
        this.sslHandlerFactory = sslHandlerFactory;
        this.uploadDir = Objects.requireNonNull(uploadDir);
        this.maxContentLength = maxContentLength;
        this.responseHeaders = Collections.unmodifiableMap(Objects.requireNonNull(responseHeaders));
    }

    public String getRestAddress() {
        return this.restAddress;
    }

    public String getRestBindAddress() {
        return this.restBindAddress;
    }

    public int getRestBindPort() {
        return this.restBindPort;
    }

    @Nullable
    public SSLHandlerFactory getSslHandlerFactory() {
        return this.sslHandlerFactory;
    }

    public Path getUploadDir() {
        return this.uploadDir;
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public static RestServerEndpointConfiguration fromConfiguration(Configuration config) throws ConfigurationException {
        SSLHandlerFactory sslHandlerFactory;
        Preconditions.checkNotNull((Object)config);
        String restAddress = (String)Preconditions.checkNotNull((Object)config.getString(RestOptions.ADDRESS), (String)"%s must be set", (Object[])new Object[]{RestOptions.ADDRESS.key()});
        String restBindAddress = config.getString(RestOptions.BIND_ADDRESS);
        int port = config.getInteger(RestOptions.PORT);
        if (SSLUtils.isRestSSLEnabled(config)) {
            try {
                sslHandlerFactory = SSLUtils.createRestServerSSLEngineFactory(config);
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to initialize SSLEngineFactory for REST server endpoint.", (Throwable)e);
            }
        } else {
            sslHandlerFactory = null;
        }
        Path uploadDir = Paths.get(config.getString(WebOptions.UPLOAD_DIR, config.getString(WebOptions.TMP_DIR)), "flink-web-upload");
        int maxContentLength = config.getInteger(RestOptions.SERVER_MAX_CONTENT_LENGTH);
        Map<String, String> responseHeaders = Collections.singletonMap("Access-Control-Allow-Origin", config.getString(WebOptions.ACCESS_CONTROL_ALLOW_ORIGIN));
        return new RestServerEndpointConfiguration(restAddress, restBindAddress, port, sslHandlerFactory, uploadDir, maxContentLength, responseHeaders);
    }
}

