/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.clusterframework.FlinkResourceManager;
import org.apache.flink.runtime.clusterframework.standalone.StandaloneResourceManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManager$;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.messages.JobManagerMessages$RequestRunningJobsStatus$;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.minicluster.FlinkMiniCluster;
import org.apache.flink.runtime.state.TaskExecutorLocalStateStoresManager;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.util.NetUtils;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple10;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r=g\u0001B\u0001\u0003\u00015\u0011Q\u0003T8dC24E.\u001b8l\u001b&t\u0017n\u00117vgR,'O\u0003\u0002\u0004\t\u0005YQ.\u001b8jG2,8\u000f^3s\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0011\r2Lgn['j]&\u001cE.^:uKJD\u0011b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001\u0006\u000e\u0002#U\u001cXM]\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!!\u0007\f\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0013\t\u0019\u0002\u0003C\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001eG\u0005A\u0002.[4i\u0003Z\f\u0017\u000e\\1cS2LG/_*feZL7-Z:\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001\"\u0011\u0001\u00055jO\"\fg/Y5mC\nLG.\u001b;z\u0013\t\u0011sD\u0001\rIS\u001eD\u0017I^1jY\u0006\u0014\u0017\u000e\\5usN+'O^5dKNL!\u0001\b\t\t\u0013\u0015\u0002!\u0011!Q\u0001\n\u0019b\u0013!E:j]\u001edW-Q2u_J\u001c\u0016p\u001d;f[B\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t9!i\\8mK\u0006t\u0017BA\u0017\u0011\u0003Q)8/Z*j]\u001edW-Q2u_J\u001c\u0016p\u001d;f[\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"B!\r\u001a4iA\u0011q\u0002\u0001\u0005\u0006'9\u0002\r\u0001\u0006\u0005\u000699\u0002\r!\b\u0005\u0006K9\u0002\rA\n\u0005\u0006_\u0001!\tA\u000e\u000b\u0004c]B\u0004\"B\n6\u0001\u0004!\u0002\"B\u00176\u0001\u00041\u0003\"B\u0018\u0001\t\u0003QDCA\u0019<\u0011\u0015\u0019\u0012\b1\u0001\u0015\u0011\u0015i\u0004\u0001\"\u0011?\u0003U9WM\\3sCR,7i\u001c8gS\u001e,(/\u0019;j_:$\"\u0001F \t\u000bMa\u0004\u0019\u0001\u000b\t\u000f\u0005\u0003!\u0019!C\u0001\u0005\u0006y!n\u001c2NC:\fw-\u001a:DY\u0006\u001c8/F\u0001Da\t!\u0015\u000bE\u0002F\u0019>s!A\u0012&\u0011\u0005\u001dCS\"\u0001%\u000b\u0005%c\u0011A\u0002\u001fs_>$h(\u0003\u0002LQ\u00051\u0001K]3eK\u001aL!!\u0014(\u0003\u000b\rc\u0017m]:\u000b\u0005-C\u0003C\u0001)R\u0019\u0001!\u0011BU*\u0002\u0002\u0003\u0005)\u0011A+\u0003\u0007}#\u0013\u0007\u0003\u0004U\u0001\u0001\u0006IaQ\u0001\u0011U>\u0014W*\u00198bO\u0016\u00148\t\\1tg\u0002\n\"AV-\u0011\u0005\u001d:\u0016B\u0001-)\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AW/\u000e\u0003mS!\u0001\u0018\u0003\u0002\u0015)|'-\\1oC\u001e,'/\u0003\u0002_7\nQ!j\u001c2NC:\fw-\u001a:\t\u000f\u0001\u0004!\u0019!C\u0001C\u0006\u0001B/Y:l\u001b\u0006t\u0017mZ3s\u00072\f7o]\u000b\u0002EB\u00121-\u001a\t\u0004\u000b2#\u0007C\u0001)f\t%1w-!A\u0001\u0002\u000b\u0005\u0011NA\u0002`IIBa\u0001\u001b\u0001!\u0002\u0013\u0011\u0017!\u0005;bg.l\u0015M\\1hKJ\u001cE.Y:tAE\u0011aK\u001b\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[\u0012\t1\u0002^1tW6\fg.Y4fe&\u0011q\u000e\u001c\u0002\f)\u0006\u001c8.T1oC\u001e,'\u000fC\u0004r\u0001\t\u0007I\u0011\u0001:\u0002)5,Wn\u001c:z\u0003J\u001c\u0007.\u001b<jgR\u001cE.Y:t+\u0005\u0019\bG\u0001;w!\r)E*\u001e\t\u0003!Z$\u0011b\u001e=\u0002\u0002\u0003\u0005)\u0011\u0001>\u0003\u0007}#3\u0007\u0003\u0004z\u0001\u0001\u0006Ia]\u0001\u0016[\u0016lwN]=Be\u000eD\u0017N^5ti\u000ec\u0017m]:!#\t16\u0010\u0005\u0002[y&\u0011Qp\u0017\u0002\u0010\u001b\u0016lwN]=Be\u000eD\u0017N^5ti\"Aq\u0010\u0001b\u0001\n\u0003\t\t!\u0001\u000bsKN|WO]2f\u001b\u0006t\u0017mZ3s\u00072\f7o]\u000b\u0003\u0003\u0007\u0001D!!\u0002\u0002\nA!Q\tTA\u0004!\r\u0001\u0016\u0011\u0002\u0003\r\u0003\u0017\ti!!A\u0001\u0002\u000b\u0005\u0011\u0011\u0003\u0002\u0004?\u0012\"\u0004\u0002CA\b\u0001\u0001\u0006I!a\u0001\u0002+I,7o\\;sG\u0016l\u0015M\\1hKJ\u001cE.Y:tAE\u0019a+a\u00051\t\u0005U\u00111\u0005\t\u0007\u0003/\ti\"!\t\u000e\u0005\u0005e!bAA\u000e\t\u0005\u00012\r\\;ti\u0016\u0014hM]1nK^|'o[\u0005\u0005\u0003?\tIB\u0001\u000bGY&t7NU3t_V\u00148-Z'b]\u0006<WM\u001d\t\u0004!\u0006\rB\u0001DA\u0013\u0003O\t\t\u0011!A\u0003\u0002\u0005%\"aA0%k\u0011a\u00111BA\u0007\u0003\u0003\r\tQ!\u0001\u0002\u0012E\u0019a+a\u000b\u0011\t\u00055\u00121G\u0007\u0003\u0003_QA!!\r\u0002\u001a\u0005)A/\u001f9fg&!\u0011QGA\u0018\u0005U\u0011Vm]8ve\u000e,\u0017\n\u0012*fiJLWM^1cY\u0016Dq!!\u000f\u0001\t\u0003\nY$A\bti\u0006\u0014HOS8c\u001b\u0006t\u0017mZ3s)!\ti$!\u0014\u0002X\u0005\u0005\u0004\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0006C\u000e$xN\u001d\u0006\u0003\u0003\u000f\nA!Y6lC&!\u00111JA!\u0005!\t5\r^8s%\u00164\u0007\u0002CA(\u0003o\u0001\r!!\u0015\u0002\u000b%tG-\u001a=\u0011\u0007\u001d\n\u0019&C\u0002\u0002V!\u00121!\u00138u\u0011!\tI&a\u000eA\u0002\u0005m\u0013AB:zgR,W\u000e\u0005\u0003\u0002@\u0005u\u0013\u0002BA0\u0003\u0003\u00121\"Q2u_J\u001c\u0016p\u001d;f[\"A\u00111MA\u001c\u0001\u0004\t)'\u0001\bpaR\u0014Vm\u001d;BI\u0012\u0014Xm]:\u0011\u000b\u001d\n9'a\u001b\n\u0007\u0005%\u0004F\u0001\u0004PaRLwN\u001c\t\u0004\u000b\u00065\u0014bAA8\u001d\n11\u000b\u001e:j]\u001eDq!a\u001d\u0001\t\u0003\n)(\u0001\u000bti\u0006\u0014HOU3t_V\u00148-Z'b]\u0006<WM\u001d\u000b\u0007\u0003{\t9(!\u001f\t\u0011\u0005=\u0013\u0011\u000fa\u0001\u0003#B\u0001\"!\u0017\u0002r\u0001\u0007\u00111\f\u0005\b\u0003{\u0002A\u0011IA@\u0003A\u0019H/\u0019:u)\u0006\u001c8.T1oC\u001e,'\u000f\u0006\u0004\u0002>\u0005\u0005\u00151\u0011\u0005\t\u0003\u001f\nY\b1\u0001\u0002R!A\u0011\u0011LA>\u0001\u0004\tY\u0006C\u0004\u0002\b\u0002!\t!!#\u0002\u001f\u001d,G/\u0011:dQ&4X\r\u0015:paN$\u0002\"a#\u0002\u0012\u0006}\u00151\u0015\t\u0005\u0003\u007f\ti)\u0003\u0003\u0002\u0010\u0006\u0005#!\u0002)s_B\u001c\b\u0002CAJ\u0003\u000b\u0003\r!!&\u0002\u0019\u0005\u00148\r[5wK\u000ec\u0017m]:1\t\u0005]\u00151\u0014\t\u0005\u000b2\u000bI\nE\u0002Q\u00037#1\"!(\u0002\u0012\u0006\u0005\t\u0011!B\u0001u\n\u0019q\f\n\u001c\t\u0011\u0005\u0005\u0016Q\u0011a\u0001\u0003#\nA\"\u0019:dQ&4XmQ8v]RD\u0001\"!*\u0002\u0006\u0002\u0007\u0011qU\u0001\u000bCJD\u0017N^3QCRD\u0007#B\u0014\u0002h\u0005%\u0006\u0003BAV\u0003kk!!!,\u000b\t\u0005=\u0016\u0011W\u0001\u0003MNT1!a-\u0007\u0003\u0011\u0019wN]3\n\t\u0005]\u0016Q\u0016\u0002\u0005!\u0006$\b\u000eC\u0004\u0002<\u0002!\t!!0\u0002%\u001d,GOS8c\u001b\u0006t\u0017mZ3s!J|\u0007o\u001d\u000b%\u0003\u0017\u000by,a3\u0002N\u0006\u0015\u0018q^A\u0000\u0005\u001b\u0011iB!\r\u00036\t%#1\fB6\u0005k\u0012)I!#\u0003\u001e\"9\u0011)!/A\u0002\u0005\u0005\u0007\u0007BAb\u0003\u000f\u0004B!\u0012'\u0002FB\u0019\u0001+a2\u0005\u0017\u0005%\u0017qXA\u0001\u0002\u0003\u0015\t!\u0016\u0002\u0004?\u0012:\u0004BB\f\u0002:\u0002\u0007A\u0003\u0003\u0005\u0002P\u0006e\u0006\u0019AAi\u000391W\u000f^;sK\u0016CXmY;u_J\u0004B!a5\u0002b6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fI.\u0001\u0006d_:\u001cWO\u001d:f]RTA!a7\u0002^\u0006!Q\u000f^5m\u0015\t\ty.\u0001\u0003kCZ\f\u0017\u0002BAr\u0003+\u0014\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011!\t9/!/A\u0002\u0005%\u0018AC5p\u000bb,7-\u001e;peB!\u00111[Av\u0013\u0011\ti/!6\u0003\u0011\u0015CXmY;u_JD\u0001\"!=\u0002:\u0002\u0007\u00111_\u0001\u0010S:\u001cH/\u00198dK6\u000bg.Y4feB!\u0011Q_A~\u001b\t\t9PC\u0002\u0002z\u0012\t\u0001\"\u001b8ti\u0006t7-Z\u0005\u0005\u0003{\f9PA\bJ]N$\u0018M\\2f\u001b\u0006t\u0017mZ3s\u0011!\u0011\t!!/A\u0002\t\r\u0011!C:dQ\u0016$W\u000f\\3s!\u0011\u0011)A!\u0003\u000e\u0005\t\u001d!b\u0001B\u00017&!!1\u0002B\u0004\u0005%\u00196\r[3ek2,'\u000f\u0003\u0005\u0003\u0010\u0005e\u0006\u0019\u0001B\t\u0003)\u0011Gn\u001c2TKJ4XM\u001d\t\u0005\u0005'\u0011I\"\u0004\u0002\u0003\u0016)\u0019!q\u0003\u0003\u0002\t\tdwNY\u0005\u0005\u00057\u0011)B\u0001\u0006CY>\u00147+\u001a:wKJD\u0001Ba\b\u0002:\u0002\u0007!\u0011E\u0001\u0014Y&\u0014'/\u0019:z\u0007\u0006\u001c\u0007.Z'b]\u0006<WM\u001d\t\u0005\u0005G\u0011i#\u0004\u0002\u0003&)!!q\u0005B\u0015\u00031a\u0017N\u0019:bef\u001c\u0017m\u00195f\u0015\r\u0011Y\u0003B\u0001\nKb,7-\u001e;j_:LAAa\f\u0003&\t9\"\t\\8c\u0019&\u0014'/\u0019:z\u0007\u0006\u001c\u0007.Z'b]\u0006<WM\u001d\u0005\t\u0005g\tI\f1\u0001\u0002>\u00059\u0011M]2iSZ,\u0007\u0002\u0003B\u001c\u0003s\u0003\rA!\u000f\u0002-I,7\u000f^1siN#(/\u0019;fOf4\u0015m\u0019;pef\u0004BAa\u000f\u0003F5\u0011!Q\b\u0006\u0005\u0005\u007f\u0011\t%A\u0004sKN$\u0018M\u001d;\u000b\u0007\t\rC!\u0001\bfq\u0016\u001cW\u000f^5p]\u001e\u0014\u0018\r\u001d5\n\t\t\u001d#Q\b\u0002\u0017%\u0016\u001cH/\u0019:u'R\u0014\u0018\r^3hs\u001a\u000b7\r^8ss\"A!1JA]\u0001\u0004\u0011i%A\u0004uS6,w.\u001e;\u0011\t\t=#qK\u0007\u0003\u0005#RAAa\u0015\u0003V\u0005AA-\u001e:bi&|gNC\u0002\u0002X\"JAA!\u0017\u0003R\tqa)\u001b8ji\u0016$UO]1uS>t\u0007\u0002\u0003B/\u0003s\u0003\rAa\u0018\u0002+1,\u0017\rZ3s\u000b2,7\r^5p]N+'O^5dKB!!\u0011\rB4\u001b\t\u0011\u0019GC\u0002\u0003f\u0011\ta\u0002\\3bI\u0016\u0014X\r\\3di&|g.\u0003\u0003\u0003j\t\r$!\u0006'fC\u0012,'/\u00127fGRLwN\\*feZL7-\u001a\u0005\t\u0005[\nI\f1\u0001\u0003p\u000512/\u001e2nSR$X\r\u001a&pE\u001e\u0013\u0018\r\u001d5Ti>\u0014X\rE\u0002[\u0005cJ1Aa\u001d\\\u0005Y\u0019VOY7jiR,GMS8c\u000fJ\f\u0007\u000f[*u_J,\u0007\u0002\u0003B<\u0003s\u0003\rA!\u001f\u00023\rDWmY6q_&tGOU3d_Z,'/\u001f$bGR|'/\u001f\t\u0005\u0005w\u0012\t)\u0004\u0002\u0003~)\u0019!q\u0010\u0003\u0002\u0015\rDWmY6q_&tG/\u0003\u0003\u0003\u0004\nu$!G\"iK\u000e\\\u0007o\\5oiJ+7m\u001c<fef4\u0015m\u0019;pefD\u0001Ba\"\u0002:\u0002\u0007!QJ\u0001\u0013U>\u0014'+Z2pm\u0016\u0014\u0018\u0010V5nK>,H\u000f\u0003\u0005\u0003\f\u0006e\u0006\u0019\u0001BG\u0003UQwNY'b]\u0006<WM]'fiJL7m\u0012:pkB\u0004BAa$\u0003\u001a6\u0011!\u0011\u0013\u0006\u0005\u0005'\u0013)*\u0001\u0004he>,\bo\u001d\u0006\u0004\u0005/#\u0011aB7fiJL7m]\u0005\u0005\u00057\u0013\tJA\u000bK_\nl\u0015M\\1hKJlU\r\u001e:jG\u001e\u0013x.\u001e9\t\u0011\u0005\r\u0014\u0011\u0018a\u0001\u0003KBqA!)\u0001\t\u0003\u0011\u0019+A\nhKR$\u0016m]6NC:\fw-\u001a:Qe>\u00048\u000f\u0006\u000b\u0002\f\n\u0015&\u0011\u0017Ba\u0005\u0017\u0014)N!:\u0003~\u000e51Q\u0004\u0005\bA\n}\u0005\u0019\u0001BTa\u0011\u0011IK!,\u0011\t\u0015c%1\u0016\t\u0004!\n5Fa\u0003BX\u0005K\u000b\t\u0011!A\u0003\u0002%\u00141a\u0018\u00139\u0011!\u0011\u0019La(A\u0002\tU\u0016!\u0005;bg.l\u0015M\\1hKJ\u001cuN\u001c4jOB!!q\u0017B_\u001b\t\u0011ILC\u0002\u0003<\u0012\tA\u0002^1tW\u0016DXmY;u_JLAAa0\u0003:\nAB+Y:l\u001b\u0006t\u0017mZ3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0011\t\r'q\u0014a\u0001\u0005\u000b\f!B]3t_V\u00148-Z%E!\u0011\tiCa2\n\t\t%\u0017q\u0006\u0002\u000b%\u0016\u001cx.\u001e:dK&#\u0005\u0002\u0003Bg\u0005?\u0003\rAa4\u0002'Q\f7o['b]\u0006<WM\u001d'pG\u0006$\u0018n\u001c8\u0011\u0007-\u0014\t.C\u0002\u0003T2\u00141\u0003V1tW6\u000bg.Y4fe2{7-\u0019;j_:D\u0001Ba6\u0003 \u0002\u0007!\u0011\\\u0001\u000e[\u0016lwN]=NC:\fw-\u001a:\u0011\t\tm'\u0011]\u0007\u0003\u0005;T1Aa8\u0005\u0003\u0019iW-\\8ss&!!1\u001dBo\u00055iU-\\8ss6\u000bg.Y4fe\"A!q\u001dBP\u0001\u0004\u0011I/A\u0005j_6\u000bg.Y4feB!!1\u001eB}\u001b\t\u0011iO\u0003\u0003\u0003p\nE\u0018!C5p[\u0006t\u0017mZ3s\u0015\u0011\u0011\u0019P!>\u0002\t\u0011L7o\u001b\u0006\u0004\u0005o$\u0011AA5p\u0013\u0011\u0011YP!<\u0003\u0013%{U*\u00198bO\u0016\u0014\b\u0002\u0003B\u0000\u0005?\u0003\ra!\u0001\u0002%9,Go^8sW\u0016sg/\u001b:p]6,g\u000e\u001e\t\u0005\u0007\u0007\u0019I!\u0004\u0002\u0004\u0006)!1q\u0001B{\u0003\u001dqW\r^<pe.LAaa\u0003\u0004\u0006\t\u0011b*\u001a;x_J\\WI\u001c<je>tW.\u001a8u\u0011!\u0019yAa(A\u0002\rE\u0011A\t;bg.l\u0015M\\1hKJdunY1m'R\fG/Z*u_J,7/T1oC\u001e,'\u000f\u0005\u0003\u0004\u0014\reQBAB\u000b\u0015\r\u00199\u0002B\u0001\u0006gR\fG/Z\u0005\u0005\u00077\u0019)BA\u0012UCN\\W\t_3dkR|'\u000fT8dC2\u001cF/\u0019;f'R|'/Z:NC:\fw-\u001a:\t\u0011\r}!q\u0014a\u0001\u0007C\ta\u0003^1tW6\u000bg.Y4fe6+GO]5d\u000fJ|W\u000f\u001d\t\u0005\u0005\u001f\u001b\u0019#\u0003\u0003\u0004&\tE%A\u0006+bg.l\u0015M\\1hKJlU\r\u001e:jG\u001e\u0013x.\u001e9\t\u000f\r%\u0002\u0001\"\u0001\u0004,\u00059r-\u001a;SKN|WO]2f\u001b\u0006t\u0017mZ3s!J|\u0007o\u001d\u000b\t\u0003\u0017\u001bica\u0012\u0004J!9qpa\nA\u0002\r=\u0002\u0007BB\u0019\u0007k\u0001B!\u0012'\u00044A\u0019\u0001k!\u000e\u0005\u0019\r]2QFA\u0001\u0002\u0003\u0015\ta!\u000f\u0003\u0007}#\u0013(E\u0002W\u0007w\u0001Da!\u0010\u0004BA1\u0011qCA\u000f\u0007\u007f\u00012\u0001UB!\t1\u0019\u0019e!\u0012\u0002\u0002\u0003\u0005)\u0011AA\u0015\u0005\u0011yF%\r\u0019\u0005\u0019\r]2QFA\u0001\u0004\u0003\u0015\ta!\u000f\t\r]\u00199\u00031\u0001\u0015\u0011!\u0019Yea\nA\u0002\r5\u0013A\u00067fC\u0012,'OU3ue&,g/\u00197TKJ4\u0018nY3\u0011\t\r=3QK\u0007\u0003\u0007#R1aa\u0015\u0005\u0003=aW-\u00193feJ,GO]5fm\u0006d\u0017\u0002BB,\u0007#\u0012a\u0003T3bI\u0016\u0014(+\u001a;sS\u00164\u0018\r\\*feZL7-\u001a\u0005\b\u00077\u0002A\u0011AB/\u0003eIg.\u001b;jC2L'0Z%P\r>\u0014X.\u0019;DY\u0006\u001c8/Z:\u0015\t\r}3Q\r\t\u0004O\r\u0005\u0014bAB2Q\t!QK\\5u\u0011\u001992\u0011\fa\u0001)!91\u0011\u000e\u0001\u0005\u0002\r-\u0014!C:fi6+Wn\u001c:z)\u0011\u0019yf!\u001c\t\u000f\r=4q\ra\u0001)\u000511m\u001c8gS\u001eDqaa\u001d\u0001\t\u0003\u0019)(\u0001\thKR$UMZ1vYR\u001cuN\u001c4jOV\tA\u0003C\u0004\u0004z\u0001!\tba\u001f\u0002#\u001d,GOS8c\u001b\u0006t\u0017mZ3s\u001d\u0006lW\r\u0006\u0003\u0002l\ru\u0004\u0002CA(\u0007o\u0002\r!!\u0015\t\u000f\r\u0005\u0005\u0001\"\u0005\u0004\u0004\u00061r-\u001a;SKN|WO]2f\u001b\u0006t\u0017mZ3s\u001d\u0006lW\r\u0006\u0003\u0002l\r\u0015\u0005\u0002CA(\u0007\u007f\u0002\r!!\u0015\t\u000f\r%\u0005\u0001\"\u0005\u0004\f\u0006qq-\u001a;Be\u000eD\u0017N^3OC6,G\u0003BA6\u0007\u001bC\u0001\"a\u0014\u0004\b\u0002\u0007\u0011\u0011\u000b\u0005\b\u0007#\u0003A\u0011ABJ\u0003Q\u0019WO\u001d:f]Rd\u0017PU;o]&twMS8cgV\u00111Q\u0013\t\u0007\u0007/\u001b\tka*\u000f\t\re5Q\u0014\b\u0004\u000f\u000em\u0015\"A\u0015\n\u0007\r}\u0005&A\u0004qC\u000e\\\u0017mZ3\n\t\r\r6Q\u0015\u0002\t\u0013R,'/\u00192mK*\u00191q\u0014\u0015\u0011\t\r%61W\u0007\u0003\u0007WSAa!,\u00040\u000611m\\7n_:T1a!-\u0007\u0003\r\t\u0007/[\u0005\u0005\u0007k\u001bYKA\u0003K_\nLE\tC\u0004\u0004:\u0002!\taa/\u00027\u001d,GoQ;se\u0016tG\u000f\\=Sk:t\u0017N\\4K_\n\u001c(*\u0019<b)\t\u0019i\f\u0005\u0004\u0004@\u000e\u00057qU\u0007\u0003\u00033LAaa1\u0002Z\n!A*[:u\u0011\u001d\u00199\r\u0001C\u0001\u0007\u0013\fqa\u001d;pa*{'\r\u0006\u0003\u0004`\r-\u0007\u0002CBg\u0007\u000b\u0004\raa*\u0002\u0005%$\u0007")
public class LocalFlinkMiniCluster
extends FlinkMiniCluster {
    private final Class<? extends JobManager> jobManagerClass = JobManager.class;
    private final Class<? extends TaskManager> taskManagerClass = TaskManager.class;
    private final Class<? extends MemoryArchivist> memoryArchivistClass = MemoryArchivist.class;
    private final Class<? extends FlinkResourceManager<? extends ResourceIDRetrievable>> resourceManagerClass = StandaloneResourceManager.class;

    /*
     * WARNING - void declaration
     */
    @Override
    public Configuration generateConfiguration(Configuration userConfiguration) {
        void var2_2;
        Configuration config = this.getDefaultConfig();
        this.setDefaultCiConfig(config);
        config.addAll(userConfiguration);
        this.setMemory(config);
        this.initializeIOFormatClasses(config);
        return var2_2;
    }

    public Class<? extends JobManager> jobManagerClass() {
        return this.jobManagerClass;
    }

    public Class<? extends TaskManager> taskManagerClass() {
        return this.taskManagerClass;
    }

    public Class<? extends MemoryArchivist> memoryArchivistClass() {
        return this.memoryArchivistClass;
    }

    public Class<? extends FlinkResourceManager<? extends ResourceIDRetrievable>> resourceManagerClass() {
        return this.resourceManagerClass;
    }

    @Override
    public ActorRef startJobManager(int index, ActorSystem system, Option<String> optRestAddress) {
        Tuple10<InstanceManager, Scheduler, BlobServer, BlobLibraryCacheManager, RestartStrategyFactory, FiniteDuration, Object, Option<Path>, FiniteDuration, JobManagerMetricGroup> tuple10;
        Configuration config = this.originalConfiguration().clone();
        String jobManagerName = this.getJobManagerName(index);
        String archiveName = this.getArchiveName(index);
        int jobManagerPort = config.getInteger(JobManagerOptions.PORT);
        if (jobManagerPort > 0) {
            config.setInteger(JobManagerOptions.PORT, jobManagerPort + index);
        }
        if ((tuple10 = JobManager$.MODULE$.createJobManagerComponents(config, this.futureExecutor(), this.ioExecutor(), super.highAvailabilityServices().createBlobStore(), (MetricRegistry)this.metricRegistryOpt().get())) == null) {
            throw new MatchError(tuple10);
        }
        InstanceManager instanceManager = (InstanceManager)tuple10._1();
        Scheduler scheduler = (Scheduler)tuple10._2();
        BlobServer blobServer = (BlobServer)tuple10._3();
        BlobLibraryCacheManager libraryCacheManager = (BlobLibraryCacheManager)tuple10._4();
        RestartStrategyFactory restartStrategyFactory = (RestartStrategyFactory)tuple10._5();
        FiniteDuration timeout = (FiniteDuration)tuple10._6();
        int archiveCount = BoxesRunTime.unboxToInt((Object)tuple10._7());
        Option archivePath = (Option)tuple10._8();
        FiniteDuration jobRecoveryTimeout = (FiniteDuration)tuple10._9();
        JobManagerMetricGroup jobManagerMetricGroup = (JobManagerMetricGroup)tuple10._10();
        Tuple10 tuple102 = new Tuple10((Object)instanceManager, (Object)scheduler, (Object)blobServer, (Object)libraryCacheManager, (Object)restartStrategyFactory, (Object)timeout, (Object)BoxesRunTime.boxToInteger((int)archiveCount), (Object)archivePath, (Object)jobRecoveryTimeout, (Object)jobManagerMetricGroup);
        Tuple10 tuple103 = tuple102;
        InstanceManager instanceManager2 = (InstanceManager)tuple103._1();
        Scheduler scheduler2 = (Scheduler)tuple103._2();
        BlobServer blobServer2 = (BlobServer)tuple103._3();
        BlobLibraryCacheManager libraryCacheManager2 = (BlobLibraryCacheManager)tuple103._4();
        RestartStrategyFactory restartStrategyFactory2 = (RestartStrategyFactory)tuple103._5();
        FiniteDuration timeout2 = (FiniteDuration)tuple103._6();
        int archiveCount2 = BoxesRunTime.unboxToInt((Object)tuple103._7());
        Option archivePath2 = (Option)tuple103._8();
        FiniteDuration jobRecoveryTimeout2 = (FiniteDuration)tuple103._9();
        JobManagerMetricGroup jobManagerMetricGroup2 = (JobManagerMetricGroup)tuple103._10();
        ActorRef archive = system.actorOf(this.getArchiveProps(this.memoryArchivistClass(), archiveCount2, (Option<Path>)archivePath2), archiveName);
        return system.actorOf(this.getJobManagerProps(this.jobManagerClass(), config, this.futureExecutor(), this.ioExecutor(), instanceManager2, scheduler2, blobServer2, libraryCacheManager2, archive, restartStrategyFactory2, timeout2, super.highAvailabilityServices().getJobManagerLeaderElectionService(HighAvailabilityServices.DEFAULT_JOB_ID), super.highAvailabilityServices().getSubmittedJobGraphStore(), super.highAvailabilityServices().getCheckpointRecoveryFactory(), jobRecoveryTimeout2, jobManagerMetricGroup2, optRestAddress), jobManagerName);
    }

    @Override
    public ActorRef startResourceManager(int index, ActorSystem system) {
        Configuration config = this.originalConfiguration().clone();
        String resourceManagerName = this.getResourceManagerName(index);
        int resourceManagerPort = config.getInteger(ResourceManagerOptions.IPC_PORT);
        if (resourceManagerPort > 0) {
            config.setInteger(ResourceManagerOptions.IPC_PORT, resourceManagerPort + index);
        }
        Props resourceManagerProps = this.getResourceManagerProps(this.resourceManagerClass(), config, super.highAvailabilityServices().getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID));
        return system.actorOf(resourceManagerProps, resourceManagerName);
    }

    @Override
    public ActorRef startTaskManager(int index, ActorSystem system) {
        Integer rpcPort;
        Configuration config = this.originalConfiguration().clone();
        String rpcPortRange = config.getString(TaskManagerOptions.RPC_PORT);
        Iterator rpcPortIterator = NetUtils.getPortRangeFromString((String)rpcPortRange);
        int dataPort = config.getInteger(TaskManagerOptions.DATA_PORT);
        if (rpcPortIterator.hasNext() && Predef$.MODULE$.Integer2int(rpcPort = (Integer)rpcPortIterator.next()) > 0) {
            config.setInteger("taskmanager.rpc.port", Predef$.MODULE$.Integer2int(rpcPort) + index);
        }
        if (dataPort > 0) {
            config.setInteger(TaskManagerOptions.DATA_PORT, dataPort + index);
        }
        boolean localExecution = this.numTaskManagers() == 1;
        String taskManagerActorName = super.useSingleActorSystem() ? new StringBuilder(12).append("taskmanager_").append(index + 1).toString() : "taskmanager";
        ResourceID resourceID = ResourceID.generate();
        InetAddress taskManagerAddress = InetAddress.getByName(this.hostname());
        TaskManagerConfiguration taskManagerConfiguration = TaskManagerConfiguration.fromConfiguration(config);
        TaskManagerServicesConfiguration taskManagerServicesConfiguration = TaskManagerServicesConfiguration.fromConfiguration(config, taskManagerAddress, localExecution);
        TaskManagerServices taskManagerServices = TaskManagerServices.fromConfiguration(taskManagerServicesConfiguration, resourceID, this.ioExecutor(), EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag(), EnvironmentInformation.getMaxJvmHeapMemory());
        TaskManagerMetricGroup taskManagerMetricGroup = MetricUtils.instantiateTaskManagerMetricGroup((MetricRegistry)this.metricRegistryOpt().get(), taskManagerServices.getTaskManagerLocation(), taskManagerServices.getNetworkEnvironment(), taskManagerServicesConfiguration.getSystemResourceMetricsProbingInterval());
        Props props = this.getTaskManagerProps(this.taskManagerClass(), taskManagerConfiguration, resourceID, taskManagerServices.getTaskManagerLocation(), taskManagerServices.getMemoryManager(), taskManagerServices.getIOManager(), taskManagerServices.getNetworkEnvironment(), taskManagerServices.getTaskManagerStateStore(), taskManagerMetricGroup);
        return system.actorOf(props, taskManagerActorName);
    }

    public Props getArchiveProps(Class<? extends MemoryArchivist> archiveClass, int archiveCount, Option<Path> arhivePath) {
        return JobManager$.MODULE$.getArchiveProps(archiveClass, archiveCount, (Option<Path>)Option$.MODULE$.empty());
    }

    public Props getJobManagerProps(Class<? extends JobManager> jobManagerClass, Configuration configuration, ScheduledExecutorService futureExecutor, Executor ioExecutor, InstanceManager instanceManager, Scheduler scheduler, BlobServer blobServer, BlobLibraryCacheManager libraryCacheManager, ActorRef archive, RestartStrategyFactory restartStrategyFactory, FiniteDuration timeout, LeaderElectionService leaderElectionService, SubmittedJobGraphStore submittedJobGraphStore, CheckpointRecoveryFactory checkpointRecoveryFactory, FiniteDuration jobRecoveryTimeout, JobManagerMetricGroup jobManagerMetricGroup, Option<String> optRestAddress) {
        return JobManager$.MODULE$.getJobManagerProps(jobManagerClass, configuration, futureExecutor, ioExecutor, instanceManager, scheduler, blobServer, libraryCacheManager, archive, restartStrategyFactory, timeout, leaderElectionService, submittedJobGraphStore, checkpointRecoveryFactory, jobRecoveryTimeout, jobManagerMetricGroup, optRestAddress);
    }

    public Props getTaskManagerProps(Class<? extends TaskManager> taskManagerClass, TaskManagerConfiguration taskManagerConfig, ResourceID resourceID, TaskManagerLocation taskManagerLocation, MemoryManager memoryManager, IOManager ioManager, NetworkEnvironment networkEnvironment, TaskExecutorLocalStateStoresManager taskManagerLocalStateStoresManager, TaskManagerMetricGroup taskManagerMetricGroup) {
        return TaskManager$.MODULE$.getTaskManagerProps(taskManagerClass, taskManagerConfig, resourceID, taskManagerLocation, memoryManager, ioManager, networkEnvironment, taskManagerLocalStateStoresManager, super.highAvailabilityServices(), taskManagerMetricGroup);
    }

    public Props getResourceManagerProps(Class<? extends FlinkResourceManager<? extends ResourceIDRetrievable>> resourceManagerClass, Configuration configuration, LeaderRetrievalService leaderRetrievalService) {
        return FlinkResourceManager.getResourceManagerProps(resourceManagerClass, configuration, leaderRetrievalService);
    }

    public void initializeIOFormatClasses(Configuration configuration) {
        try {
            Method om = FileOutputFormat.class.getDeclaredMethod("initDefaultsFromConfiguration", Configuration.class);
            om.setAccessible(true);
            om.invoke(null, configuration);
        }
        catch (Exception e) {
            this.LOG().error("Cannot (re) initialize the globally loaded defaults. Some classes might not follow the specified default behaviour.");
        }
    }

    public void setMemory(Configuration config) {
        block0: {
            if (!config.getString(TaskManagerOptions.MANAGED_MEMORY_SIZE).equals(TaskManagerOptions.MANAGED_MEMORY_SIZE.defaultValue())) break block0;
            int numTaskManager = config.getInteger("local.number-taskmanager", 1);
            float memoryFraction = config.getFloat(TaskManagerOptions.MANAGED_MEMORY_FRACTION);
            long memorySize = EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag();
            memorySize /= (long)(numTaskManager + 1);
            memorySize -= TaskManagerServices.calculateNetworkBufferMemory(memorySize, config);
            memorySize = (long)((double)memorySize * (double)memoryFraction);
            config.setString(TaskManagerOptions.MANAGED_MEMORY_SIZE, new StringBuilder(1).append(memorySize >>= 20).append("m").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Configuration getDefaultConfig() {
        void var1_1;
        Configuration config = new Configuration();
        config.setString(JobManagerOptions.ADDRESS, this.hostname());
        config.setInteger(JobManagerOptions.PORT, 0);
        config.setInteger("local.number-taskmanager", 1);
        config.setInteger(NettyConfig.NUM_THREADS_CLIENT, 1);
        config.setInteger(NettyConfig.NUM_THREADS_SERVER, 2);
        return var1_1;
    }

    public String getJobManagerName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder(11).append("jobmanager_").append(index + 1).toString() : "jobmanager";
    }

    public String getResourceManagerName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder(16).append("resourcemanager_").append(index + 1).toString() : "resourcemanager";
    }

    public String getArchiveName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder(8).append("archive_").append(index + 1).toString() : "archive";
    }

    public Iterable<JobID> currentlyRunningJobs() {
        ActorGateway leader = this.getLeaderGateway(this.timeout());
        Future future = leader.ask(JobManagerMessages$RequestRunningJobsStatus$.MODULE$, this.timeout()).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.RunningJobsStatus.class));
        return (Iterable)((JobManagerMessages.RunningJobsStatus)Await$.MODULE$.result((Awaitable)future, (Duration)this.timeout())).runningJobs().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getJobId(), Iterable$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public List<JobID> getCurrentlyRunningJobsJava() {
        void var1_1;
        ArrayList list = new ArrayList();
        this.currentlyRunningJobs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)list.add(x$1)));
        return var1_1;
    }

    public void stopJob(JobID id) {
        ActorGateway leader = this.getLeaderGateway(this.timeout());
        Future response = leader.ask(new JobManagerMessages.StopJob(id), this.timeout()).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.StoppingResponse.class));
        JobManagerMessages.StoppingResponse rc = (JobManagerMessages.StoppingResponse)Await$.MODULE$.result((Awaitable)response, (Duration)this.timeout());
        JobManagerMessages.StoppingResponse stoppingResponse = rc;
        if (stoppingResponse instanceof JobManagerMessages.StoppingFailure) {
            JobManagerMessages.StoppingFailure stoppingFailure = (JobManagerMessages.StoppingFailure)stoppingResponse;
            throw new Exception(new StringBuilder(33).append("Stopping the job with ID ").append(id).append(" failed.").toString(), stoppingFailure.cause());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration, HighAvailabilityServices highAvailabilityServices, boolean singleActorSystem) {
        super(userConfiguration, highAvailabilityServices, singleActorSystem);
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration, boolean useSingleActorSystem) {
        this(userConfiguration, HighAvailabilityServicesUtils.createAvailableOrEmbeddedServices(userConfiguration, (Executor)ExecutionContext$.MODULE$.global()), useSingleActorSystem);
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration) {
        this(userConfiguration, true);
    }
}

