/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlot;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlotActions;
import org.apache.flink.runtime.jobmaster.slotpool.SchedulingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SingleLogicalSlot;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotSharingManager {
    private static final Logger LOG = LoggerFactory.getLogger(SlotSharingManager.class);
    private final SlotSharingGroupId slotSharingGroupId;
    private final AllocatedSlotActions allocatedSlotActions;
    private final SlotOwner slotOwner;
    private final Map<SlotRequestId, TaskSlot> allTaskSlots;
    private final Map<SlotRequestId, MultiTaskSlot> unresolvedRootSlots;
    private final Map<TaskManagerLocation, Set<MultiTaskSlot>> resolvedRootSlots;

    SlotSharingManager(SlotSharingGroupId slotSharingGroupId, AllocatedSlotActions allocatedSlotActions, SlotOwner slotOwner) {
        this.slotSharingGroupId = (SlotSharingGroupId)((Object)Preconditions.checkNotNull((Object)((Object)slotSharingGroupId)));
        this.allocatedSlotActions = (AllocatedSlotActions)Preconditions.checkNotNull((Object)allocatedSlotActions);
        this.slotOwner = (SlotOwner)Preconditions.checkNotNull((Object)slotOwner);
        this.allTaskSlots = new HashMap<SlotRequestId, TaskSlot>(16);
        this.unresolvedRootSlots = new HashMap<SlotRequestId, MultiTaskSlot>(16);
        this.resolvedRootSlots = new HashMap<TaskManagerLocation, Set<MultiTaskSlot>>(16);
    }

    public boolean isEmpty() {
        return this.allTaskSlots.isEmpty();
    }

    public boolean contains(SlotRequestId slotRequestId) {
        return this.allTaskSlots.containsKey((Object)slotRequestId);
    }

    @Nullable
    TaskSlot getTaskSlot(SlotRequestId slotRequestId) {
        return this.allTaskSlots.get((Object)slotRequestId);
    }

    MultiTaskSlot createRootSlot(SlotRequestId slotRequestId, CompletableFuture<? extends SlotContext> slotContextFuture, SlotRequestId allocatedSlotRequestId) {
        MultiTaskSlot rootMultiTaskSlot = new MultiTaskSlot(slotRequestId, slotContextFuture, allocatedSlotRequestId);
        LOG.debug("Create multi task slot [{}] in slot [{}].", (Object)slotRequestId, (Object)allocatedSlotRequestId);
        this.allTaskSlots.put(slotRequestId, rootMultiTaskSlot);
        this.unresolvedRootSlots.put(slotRequestId, rootMultiTaskSlot);
        slotContextFuture.whenComplete((slotContext, throwable) -> {
            if (slotContext != null) {
                MultiTaskSlot resolvedRootNode = this.unresolvedRootSlots.remove((Object)slotRequestId);
                if (resolvedRootNode != null) {
                    LOG.trace("Fulfill multi task slot [{}] with slot [{}].", (Object)slotRequestId, (Object)slotContext.getAllocationId());
                    Set innerCollection = this.resolvedRootSlots.computeIfAbsent(slotContext.getTaskManagerLocation(), taskManagerLocation -> new HashSet(4));
                    innerCollection.add(resolvedRootNode);
                }
            } else {
                rootMultiTaskSlot.release((Throwable)throwable);
            }
        });
        return rootMultiTaskSlot;
    }

    @Nullable
    MultiTaskSlotLocality getResolvedRootSlot(AbstractID groupId, SchedulingStrategy matcher, SlotProfile slotProfile) {
        Collection<Set<MultiTaskSlot>> resolvedRootSlotsValues = this.resolvedRootSlots.values();
        return matcher.findMatchWithLocality(slotProfile, () -> resolvedRootSlotsValues.stream().flatMap(Collection::stream), multiTaskSlot -> multiTaskSlot.getSlotContextFuture().join(), multiTaskSlot -> !multiTaskSlot.contains(groupId), MultiTaskSlotLocality::of);
    }

    @Nullable
    MultiTaskSlot getUnresolvedRootSlot(AbstractID groupId) {
        for (MultiTaskSlot multiTaskSlot : this.unresolvedRootSlots.values()) {
            if (multiTaskSlot.contains(groupId)) continue;
            return multiTaskSlot;
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{\n\tgroupId=").append((Object)this.slotSharingGroupId).append('\n');
        builder.append("\tunresolved=").append(this.unresolvedRootSlots).append('\n');
        builder.append("\tresolved=").append(this.resolvedRootSlots).append('\n');
        builder.append("\tall=").append(this.allTaskSlots).append('\n');
        return builder.append('}').toString();
    }

    @VisibleForTesting
    public Collection<MultiTaskSlot> getResolvedRootSlots() {
        return new ResolvedRootSlotValues();
    }

    @VisibleForTesting
    Collection<MultiTaskSlot> getUnresolvedRootSlots() {
        return this.unresolvedRootSlots.values();
    }

    private static final class ResolvedRootSlotIterator
    implements Iterator<MultiTaskSlot> {
        private final Iterator<Set<MultiTaskSlot>> baseIterator;
        private Iterator<MultiTaskSlot> currentIterator;

        private ResolvedRootSlotIterator(Iterator<Set<MultiTaskSlot>> baseIterator) {
            this.baseIterator = (Iterator)Preconditions.checkNotNull(baseIterator);
            this.currentIterator = baseIterator.hasNext() ? baseIterator.next().iterator() : Collections.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            this.progressToNextElement();
            return this.currentIterator.hasNext();
        }

        @Override
        public MultiTaskSlot next() {
            this.progressToNextElement();
            return this.currentIterator.next();
        }

        private void progressToNextElement() {
            while (this.baseIterator.hasNext() && !this.currentIterator.hasNext()) {
                this.currentIterator = this.baseIterator.next().iterator();
            }
        }
    }

    private final class ResolvedRootSlotValues
    extends AbstractCollection<MultiTaskSlot> {
        private ResolvedRootSlotValues() {
        }

        @Override
        public Iterator<MultiTaskSlot> iterator() {
            return new ResolvedRootSlotIterator(SlotSharingManager.this.resolvedRootSlots.values().iterator());
        }

        @Override
        public int size() {
            int numberResolvedMultiTaskSlots = 0;
            for (Set multiTaskSlots : SlotSharingManager.this.resolvedRootSlots.values()) {
                numberResolvedMultiTaskSlots += multiTaskSlots.size();
            }
            return numberResolvedMultiTaskSlots;
        }
    }

    public final class SingleTaskSlot
    extends TaskSlot {
        private final MultiTaskSlot parent;
        private final CompletableFuture<SingleLogicalSlot> singleLogicalSlotFuture;

        private SingleTaskSlot(SlotRequestId slotRequestId, AbstractID groupId, MultiTaskSlot parent, Locality locality) {
            super(slotRequestId, groupId);
            this.parent = (MultiTaskSlot)Preconditions.checkNotNull((Object)parent);
            Preconditions.checkNotNull((Object)((Object)locality));
            this.singleLogicalSlotFuture = parent.getSlotContextFuture().thenApply(slotContext -> {
                LOG.trace("Fulfill single task slot [{}] with slot [{}].", (Object)slotRequestId, (Object)slotContext.getAllocationId());
                return new SingleLogicalSlot(slotRequestId, (SlotContext)slotContext, SlotSharingManager.this.slotSharingGroupId, locality, SlotSharingManager.this.slotOwner);
            });
        }

        CompletableFuture<LogicalSlot> getLogicalSlotFuture() {
            return this.singleLogicalSlotFuture.thenApply(Function.identity());
        }

        @Override
        public void release(Throwable cause) {
            this.singleLogicalSlotFuture.completeExceptionally(cause);
            if (this.singleLogicalSlotFuture.isDone() && !this.singleLogicalSlotFuture.isCompletedExceptionally()) {
                SingleLogicalSlot singleLogicalSlot = this.singleLogicalSlotFuture.getNow(null);
                singleLogicalSlot.release(cause);
            }
            this.parent.releaseChild(this.getGroupId());
        }

        public String toString() {
            String logicalSlotString = "(pending)";
            try {
                LogicalSlot slot = this.singleLogicalSlotFuture.getNow(null);
                if (slot != null) {
                    logicalSlotString = "(requestId=" + (Object)((Object)slot.getSlotRequestId()) + ", allocationId=" + (Object)((Object)slot.getAllocationId()) + ')';
                }
            }
            catch (Exception e) {
                logicalSlotString = '(' + ExceptionUtils.stripCompletionException((Throwable)e).getMessage() + ')';
            }
            return "SingleTaskSlot{logicalSlot=" + logicalSlotString + ", request=" + (Object)((Object)this.getSlotRequestId()) + ", group=" + this.getGroupId() + '}';
        }
    }

    public final class MultiTaskSlot
    extends TaskSlot
    implements AllocatedSlot.Payload {
        private final Map<AbstractID, TaskSlot> children;
        @Nullable
        private final MultiTaskSlot parent;
        private final CompletableFuture<? extends SlotContext> slotContextFuture;
        @Nullable
        private final SlotRequestId allocatedSlotRequestId;
        private boolean releasingChildren;

        private MultiTaskSlot(SlotRequestId slotRequestId, AbstractID groupId, MultiTaskSlot parent) {
            this(slotRequestId, groupId, (MultiTaskSlot)Preconditions.checkNotNull((Object)parent), parent.getSlotContextFuture(), null);
        }

        private MultiTaskSlot(SlotRequestId slotRequestId, CompletableFuture<? extends SlotContext> slotContextFuture, SlotRequestId allocatedSlotRequestId) {
            this(slotRequestId, null, null, slotContextFuture, allocatedSlotRequestId);
        }

        private MultiTaskSlot(@Nullable SlotRequestId slotRequestId, @Nullable AbstractID groupId, MultiTaskSlot parent, @Nullable CompletableFuture<? extends SlotContext> slotContextFuture, SlotRequestId allocatedSlotRequestId) {
            super(slotRequestId, groupId);
            this.parent = parent;
            this.slotContextFuture = (CompletableFuture)Preconditions.checkNotNull(slotContextFuture);
            this.allocatedSlotRequestId = allocatedSlotRequestId;
            this.children = new HashMap<AbstractID, TaskSlot>(16);
            this.releasingChildren = false;
            slotContextFuture.whenComplete((ignored, throwable) -> {
                if (throwable != null) {
                    this.release((Throwable)throwable);
                }
            });
        }

        CompletableFuture<? extends SlotContext> getSlotContextFuture() {
            return this.slotContextFuture;
        }

        MultiTaskSlot allocateMultiTaskSlot(SlotRequestId slotRequestId, AbstractID groupId) {
            Preconditions.checkState((!super.contains(groupId) ? 1 : 0) != 0);
            LOG.debug("Create nested multi task slot [{}] in parent multi task slot [{}] for group [{}].", new Object[]{slotRequestId, this.getSlotRequestId(), groupId});
            MultiTaskSlot inner = new MultiTaskSlot(slotRequestId, groupId, this);
            this.children.put(groupId, inner);
            SlotSharingManager.this.allTaskSlots.put(slotRequestId, inner);
            return inner;
        }

        SingleTaskSlot allocateSingleTaskSlot(SlotRequestId slotRequestId, AbstractID groupId, Locality locality) {
            Preconditions.checkState((!super.contains(groupId) ? 1 : 0) != 0);
            LOG.debug("Create single task slot [{}] in multi task slot [{}] for group {}.", new Object[]{slotRequestId, this.getSlotRequestId(), groupId});
            SingleTaskSlot leaf = new SingleTaskSlot(slotRequestId, groupId, this, locality);
            this.children.put(groupId, leaf);
            SlotSharingManager.this.allTaskSlots.put(slotRequestId, leaf);
            return leaf;
        }

        @Override
        public boolean contains(AbstractID groupId) {
            if (super.contains(groupId)) {
                return true;
            }
            for (TaskSlot taskSlot : this.children.values()) {
                if (!taskSlot.contains(groupId)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void release(Throwable cause) {
            this.releasingChildren = true;
            for (TaskSlot taskSlot : this.children.values()) {
                taskSlot.release(cause);
                SlotSharingManager.this.allTaskSlots.remove((Object)taskSlot.getSlotRequestId());
            }
            this.children.clear();
            this.releasingChildren = false;
            if (this.parent != null) {
                this.parent.releaseChild(this.getGroupId());
            } else if (SlotSharingManager.this.allTaskSlots.remove((Object)this.getSlotRequestId()) != null) {
                Set multiTaskSlots;
                SlotContext slotContext;
                MultiTaskSlot unresolvedRootSlot = (MultiTaskSlot)SlotSharingManager.this.unresolvedRootSlots.remove((Object)this.getSlotRequestId());
                if (unresolvedRootSlot == null && (slotContext = (SlotContext)this.slotContextFuture.getNow(null)) != null && (multiTaskSlots = (Set)SlotSharingManager.this.resolvedRootSlots.get(slotContext.getTaskManagerLocation())) != null) {
                    multiTaskSlots.remove(this);
                    if (multiTaskSlots.isEmpty()) {
                        SlotSharingManager.this.resolvedRootSlots.remove(slotContext.getTaskManagerLocation());
                    }
                }
                SlotSharingManager.this.allocatedSlotActions.releaseSlot(this.allocatedSlotRequestId, null, cause);
            }
        }

        private void releaseChild(AbstractID childGroupId) {
            if (!this.releasingChildren) {
                TaskSlot child = this.children.remove(childGroupId);
                if (child != null) {
                    SlotSharingManager.this.allTaskSlots.remove((Object)child.getSlotRequestId());
                }
                if (this.children.isEmpty()) {
                    this.release(new FlinkException("Release multi task slot because all children have been released."));
                }
            }
        }

        public String toString() {
            String physicalSlotDescription = "";
            try {
                physicalSlotDescription = String.valueOf(this.slotContextFuture.getNow(null));
            }
            catch (Exception e) {
                physicalSlotDescription = '(' + ExceptionUtils.stripCompletionException((Throwable)e).getMessage() + ')';
            }
            return "MultiTaskSlot{requestId=" + (Object)((Object)this.getSlotRequestId()) + ", allocatedRequestId=" + (Object)((Object)this.allocatedSlotRequestId) + ", groupId=" + this.getGroupId() + ", physicalSlot=" + physicalSlotDescription + ", children=" + this.children.values().toString() + '}';
        }
    }

    public static abstract class TaskSlot {
        private final SlotRequestId slotRequestId;
        @Nullable
        private final AbstractID groupId;

        TaskSlot(SlotRequestId slotRequestId, @Nullable AbstractID groupId) {
            this.slotRequestId = (SlotRequestId)((Object)Preconditions.checkNotNull((Object)((Object)slotRequestId)));
            this.groupId = groupId;
        }

        public SlotRequestId getSlotRequestId() {
            return this.slotRequestId;
        }

        @Nullable
        public AbstractID getGroupId() {
            return this.groupId;
        }

        public boolean contains(AbstractID groupId) {
            return Objects.equals(this.groupId, groupId);
        }

        public abstract void release(Throwable var1);
    }

    static final class MultiTaskSlotLocality {
        private final MultiTaskSlot multiTaskSlot;
        private final Locality locality;

        MultiTaskSlotLocality(MultiTaskSlot multiTaskSlot, Locality locality) {
            this.multiTaskSlot = (MultiTaskSlot)Preconditions.checkNotNull((Object)multiTaskSlot);
            this.locality = (Locality)((Object)Preconditions.checkNotNull((Object)((Object)locality)));
        }

        MultiTaskSlot getMultiTaskSlot() {
            return this.multiTaskSlot;
        }

        public Locality getLocality() {
            return this.locality;
        }

        public static MultiTaskSlotLocality of(MultiTaskSlot multiTaskSlot, Locality locality) {
            return new MultiTaskSlotLocality(multiTaskSlot, locality);
        }
    }
}

