/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSchedulingStrategy;

public class PreviousAllocationSchedulingStrategy
extends LocationPreferenceSchedulingStrategy {
    private static final PreviousAllocationSchedulingStrategy INSTANCE = new PreviousAllocationSchedulingStrategy();

    private PreviousAllocationSchedulingStrategy() {
    }

    @Override
    @Nullable
    public <IN, OUT> OUT findMatchWithLocality(@Nonnull SlotProfile slotProfile, @Nonnull Supplier<Stream<IN>> candidates, @Nonnull Function<IN, SlotInfo> contextExtractor, @Nonnull Predicate<IN> additionalRequirementsFilter, @Nonnull BiFunction<IN, Locality, OUT> resultProducer) {
        Collection<AllocationID> priorAllocations = slotProfile.getPreferredAllocations();
        if (priorAllocations.isEmpty()) {
            return super.findMatchWithLocality(slotProfile, candidates, contextExtractor, additionalRequirementsFilter, resultProducer);
        }
        return this.findPreviousAllocation(slotProfile, candidates, contextExtractor, additionalRequirementsFilter, resultProducer, priorAllocations);
    }

    @Nullable
    private <IN, OUT> OUT findPreviousAllocation(@Nonnull SlotProfile slotProfile, @Nonnull Supplier<Stream<IN>> candidates, @Nonnull Function<IN, SlotInfo> contextExtractor, @Nonnull Predicate<IN> additionalRequirementsFilter, @Nonnull BiFunction<IN, Locality, OUT> resultProducer, @Nonnull Collection<AllocationID> priorAllocations) {
        Predicate<Object> filterByAllocation = candidate -> priorAllocations.contains((Object)((SlotInfo)contextExtractor.apply(candidate)).getAllocationId());
        OUT previousAllocationCandidate = candidates.get().filter(filterByAllocation.and(additionalRequirementsFilter)).findFirst().map(result -> resultProducer.apply(result, Locality.LOCAL)).orElse(null);
        if (previousAllocationCandidate != null) {
            return previousAllocationCandidate;
        }
        Set<AllocationID> blackListedAllocationIDs = slotProfile.getPreviousExecutionGraphAllocations();
        Stream<Object> candidateStream = candidates.get();
        if (!blackListedAllocationIDs.isEmpty()) {
            candidateStream = candidateStream.filter(candidate -> !blackListedAllocationIDs.contains((Object)((SlotInfo)contextExtractor.apply(candidate)).getAllocationId()));
        }
        return this.doFindMatchWithLocality(slotProfile, candidateStream, contextExtractor, additionalRequirementsFilter, resultProducer);
    }

    public static PreviousAllocationSchedulingStrategy getInstance() {
        return INSTANCE;
    }
}

