/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.tasks;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.util.Preconditions;

public class CheckpointCoordinatorConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final long checkpointInterval;
    private final long checkpointTimeout;
    private final long minPauseBetweenCheckpoints;
    private final int maxConcurrentCheckpoints;
    private final CheckpointRetentionPolicy checkpointRetentionPolicy;
    private final boolean isExactlyOnce;

    public CheckpointCoordinatorConfiguration(long checkpointInterval, long checkpointTimeout, long minPauseBetweenCheckpoints, int maxConcurrentCheckpoints, CheckpointRetentionPolicy checkpointRetentionPolicy, boolean isExactlyOnce) {
        if (checkpointInterval < 1L || checkpointTimeout < 1L || minPauseBetweenCheckpoints < 0L || maxConcurrentCheckpoints < 1) {
            throw new IllegalArgumentException();
        }
        this.checkpointInterval = checkpointInterval;
        this.checkpointTimeout = checkpointTimeout;
        this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
        this.maxConcurrentCheckpoints = maxConcurrentCheckpoints;
        this.checkpointRetentionPolicy = (CheckpointRetentionPolicy)((Object)Preconditions.checkNotNull((Object)((Object)checkpointRetentionPolicy)));
        this.isExactlyOnce = isExactlyOnce;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public long getCheckpointTimeout() {
        return this.checkpointTimeout;
    }

    public long getMinPauseBetweenCheckpoints() {
        return this.minPauseBetweenCheckpoints;
    }

    public int getMaxConcurrentCheckpoints() {
        return this.maxConcurrentCheckpoints;
    }

    public CheckpointRetentionPolicy getCheckpointRetentionPolicy() {
        return this.checkpointRetentionPolicy;
    }

    public boolean isExactlyOnce() {
        return this.isExactlyOnce;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointCoordinatorConfiguration that = (CheckpointCoordinatorConfiguration)o;
        return this.checkpointInterval == that.checkpointInterval && this.checkpointTimeout == that.checkpointTimeout && this.minPauseBetweenCheckpoints == that.minPauseBetweenCheckpoints && this.maxConcurrentCheckpoints == that.maxConcurrentCheckpoints && this.isExactlyOnce == that.isExactlyOnce && this.checkpointRetentionPolicy == that.checkpointRetentionPolicy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checkpointInterval, this.checkpointTimeout, this.minPauseBetweenCheckpoints, this.maxConcurrentCheckpoints, this.checkpointRetentionPolicy, this.isExactlyOnce});
    }

    public String toString() {
        return "JobCheckpointingConfiguration{checkpointInterval=" + this.checkpointInterval + ", checkpointTimeout=" + this.checkpointTimeout + ", minPauseBetweenCheckpoints=" + this.minPauseBetweenCheckpoints + ", maxConcurrentCheckpoints=" + this.maxConcurrentCheckpoints + ", checkpointRetentionPolicy=" + (Object)((Object)this.checkpointRetentionPolicy) + '}';
    }
}

