/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.client;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Status;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaJobManagerGateway;
import org.apache.flink.runtime.akka.ListeningBehaviour;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.client.ClientUtils;
import org.apache.flink.runtime.client.JobClient;
import org.apache.flink.runtime.client.JobClientActor;
import org.apache.flink.runtime.client.JobClientActorSubmissionTimeoutException;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.messages.JobClientMessages;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.function.SupplierWithException;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class JobSubmissionClientActor
extends JobClientActor {
    private JobGraph jobGraph;
    private boolean jobSuccessfullySubmitted = false;
    private final Configuration clientConfig;

    public JobSubmissionClientActor(LeaderRetrievalService leaderRetrievalService, FiniteDuration timeout, boolean sysoutUpdates, Configuration clientConfig) {
        super(leaderRetrievalService, timeout, sysoutUpdates);
        this.clientConfig = clientConfig;
    }

    @Override
    public void connectedToJobManager() {
        if (this.jobGraph != null && !this.jobSuccessfullySubmitted) {
            this.tryToSubmitJob();
        }
    }

    @Override
    protected Class getClientMessageClass() {
        return JobClientMessages.SubmitJobAndWait.class;
    }

    @Override
    public void handleCustomMessage(Object message) {
        if (message instanceof JobClientMessages.SubmitJobAndWait) {
            if (this.client == null) {
                this.jobGraph = ((JobClientMessages.SubmitJobAndWait)message).jobGraph();
                if (this.jobGraph == null) {
                    this.LOG.error("Received null JobGraph");
                    this.sender().tell(this.decorateMessage(new Status.Failure((Throwable)new Exception("JobGraph is null"))), this.getSelf());
                } else {
                    this.LOG.info("Received job {} ({}).", (Object)this.jobGraph.getName(), (Object)this.jobGraph.getJobID());
                    this.client = this.getSender();
                    if (this.jobManager != null) {
                        this.tryToSubmitJob();
                    }
                }
            } else {
                String msg = "Received repeated 'SubmitJobAndWait'";
                this.LOG.error(msg);
                this.getSender().tell(this.decorateMessage(new Status.Failure((Throwable)new Exception(msg))), ActorRef.noSender());
                this.terminate();
            }
        } else if (message instanceof JobManagerMessages.JobSubmitSuccess) {
            this.LOG.info("Job {} was successfully submitted to the JobManager {}.", (Object)((JobManagerMessages.JobSubmitSuccess)message).jobId(), (Object)this.getSender().path());
            this.jobSuccessfullySubmitted = true;
        } else if (JobClientMessages.getSubmissionTimeout().equals(message)) {
            if (!this.jobSuccessfullySubmitted) {
                if (this.isClientConnected()) {
                    this.client.tell(this.decorateMessage(new Status.Failure((Throwable)((Object)new JobClientActorSubmissionTimeoutException("Job submission to the JobManager timed out. You may increase '" + AkkaOptions.CLIENT_TIMEOUT.key() + "' in case the JobManager needs more time to configure and confirm the job submission.")))), this.getSelf());
                }
                this.terminate();
            }
        } else {
            this.LOG.error("{} received unknown message: ", this.getClass());
        }
    }

    private void tryToSubmitJob() {
        this.LOG.info("Sending message to JobManager {} to submit job {} ({}) and wait for progress", new Object[]{this.jobManager.path().toString(), this.jobGraph.getName(), this.jobGraph.getJobID()});
        AkkaActorGateway jobManagerGateway = new AkkaActorGateway(this.jobManager, this.leaderSessionID);
        AkkaJobManagerGateway akkaJobManagerGateway = new AkkaJobManagerGateway(jobManagerGateway);
        this.LOG.info("Upload jar files to job manager {}.", (Object)this.jobManager.path());
        CompletableFuture<InetSocketAddress> blobServerAddressFuture = JobClient.retrieveBlobServerAddress(akkaJobManagerGateway, Time.milliseconds((long)this.timeout.toMillis()));
        CompletionStage jarUploadFuture = blobServerAddressFuture.thenAcceptAsync(blobServerAddress -> {
            try {
                ClientUtils.extractAndUploadJobGraphFiles(this.jobGraph, (SupplierWithException<BlobClient, IOException>)((SupplierWithException)() -> new BlobClient((InetSocketAddress)blobServerAddress, this.clientConfig)));
            }
            catch (FlinkException e) {
                throw new CompletionException(e);
            }
        }, (Executor)this.getContext().dispatcher());
        ((CompletableFuture)((CompletableFuture)jarUploadFuture).thenAccept(ignored -> {
            this.LOG.info("Submit job to the job manager {}.", (Object)this.jobManager.path());
            this.jobManager.tell(this.decorateMessage(new JobManagerMessages.SubmitJob(this.jobGraph, ListeningBehaviour.EXECUTION_RESULT_AND_STATE_CHANGES)), this.getSelf());
            this.getContext().system().scheduler().scheduleOnce(this.timeout, this.getSelf(), this.decorateMessage(JobClientMessages.getSubmissionTimeout()), (ExecutionContext)this.getContext().dispatcher(), ActorRef.noSender());
        })).whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                this.getSelf().tell(this.decorateMessage(new JobManagerMessages.JobResultFailure(new SerializedThrowable(ExceptionUtils.stripCompletionException((Throwable)throwable)))), ActorRef.noSender());
            }
        });
    }

    public static Props createActorProps(LeaderRetrievalService leaderRetrievalService, FiniteDuration timeout, boolean sysoutUpdates, Configuration clientConfig) {
        return Props.create(JobSubmissionClientActor.class, (Object[])new Object[]{leaderRetrievalService, timeout, sysoutUpdates, clientConfig});
    }
}

