/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StateObject;

@Internal
public class PrioritizedOperatorSubtaskState {
    private static final PrioritizedOperatorSubtaskState EMPTY_NON_RESTORED_INSTANCE = new Builder(new OperatorSubtaskState(), Collections.emptyList(), false).build();
    private final List<StateObjectCollection<OperatorStateHandle>> prioritizedManagedOperatorState;
    private final List<StateObjectCollection<OperatorStateHandle>> prioritizedRawOperatorState;
    private final List<StateObjectCollection<KeyedStateHandle>> prioritizedManagedKeyedState;
    private final List<StateObjectCollection<KeyedStateHandle>> prioritizedRawKeyedState;
    private final boolean restored;

    PrioritizedOperatorSubtaskState(@Nonnull List<StateObjectCollection<KeyedStateHandle>> prioritizedManagedKeyedState, @Nonnull List<StateObjectCollection<KeyedStateHandle>> prioritizedRawKeyedState, @Nonnull List<StateObjectCollection<OperatorStateHandle>> prioritizedManagedOperatorState, @Nonnull List<StateObjectCollection<OperatorStateHandle>> prioritizedRawOperatorState, boolean restored) {
        this.prioritizedManagedOperatorState = prioritizedManagedOperatorState;
        this.prioritizedRawOperatorState = prioritizedRawOperatorState;
        this.prioritizedManagedKeyedState = prioritizedManagedKeyedState;
        this.prioritizedRawKeyedState = prioritizedRawKeyedState;
        this.restored = restored;
    }

    @Nonnull
    public List<StateObjectCollection<OperatorStateHandle>> getPrioritizedManagedOperatorState() {
        return this.prioritizedManagedOperatorState;
    }

    @Nonnull
    public List<StateObjectCollection<OperatorStateHandle>> getPrioritizedRawOperatorState() {
        return this.prioritizedRawOperatorState;
    }

    @Nonnull
    public List<StateObjectCollection<KeyedStateHandle>> getPrioritizedManagedKeyedState() {
        return this.prioritizedManagedKeyedState;
    }

    @Nonnull
    public List<StateObjectCollection<KeyedStateHandle>> getPrioritizedRawKeyedState() {
        return this.prioritizedRawKeyedState;
    }

    @Nonnull
    public StateObjectCollection<OperatorStateHandle> getJobManagerManagedOperatorState() {
        return PrioritizedOperatorSubtaskState.lastElement(this.prioritizedManagedOperatorState);
    }

    @Nonnull
    public StateObjectCollection<OperatorStateHandle> getJobManagerRawOperatorState() {
        return PrioritizedOperatorSubtaskState.lastElement(this.prioritizedRawOperatorState);
    }

    @Nonnull
    public StateObjectCollection<KeyedStateHandle> getJobManagerManagedKeyedState() {
        return PrioritizedOperatorSubtaskState.lastElement(this.prioritizedManagedKeyedState);
    }

    @Nonnull
    public StateObjectCollection<KeyedStateHandle> getJobManagerRawKeyedState() {
        return PrioritizedOperatorSubtaskState.lastElement(this.prioritizedRawKeyedState);
    }

    public boolean isRestored() {
        return this.restored;
    }

    private static <T extends StateObject> StateObjectCollection<T> lastElement(List<StateObjectCollection<T>> list) {
        return list.get(list.size() - 1);
    }

    public static PrioritizedOperatorSubtaskState emptyNotRestored() {
        return EMPTY_NON_RESTORED_INSTANCE;
    }

    @Internal
    public static class Builder {
        @Nonnull
        private final OperatorSubtaskState jobManagerState;
        @Nonnull
        private final List<OperatorSubtaskState> alternativesByPriority;
        private final boolean restored;

        public Builder(@Nonnull OperatorSubtaskState jobManagerState, @Nonnull List<OperatorSubtaskState> alternativesByPriority) {
            this(jobManagerState, alternativesByPriority, true);
        }

        public Builder(@Nonnull OperatorSubtaskState jobManagerState, @Nonnull List<OperatorSubtaskState> alternativesByPriority, boolean restored) {
            this.jobManagerState = jobManagerState;
            this.alternativesByPriority = alternativesByPriority;
            this.restored = restored;
        }

        public PrioritizedOperatorSubtaskState build() {
            int size = this.alternativesByPriority.size();
            ArrayList managedOperatorAlternatives = new ArrayList(size);
            ArrayList managedKeyedAlternatives = new ArrayList(size);
            ArrayList rawOperatorAlternatives = new ArrayList(size);
            ArrayList rawKeyedAlternatives = new ArrayList(size);
            for (OperatorSubtaskState subtaskState : this.alternativesByPriority) {
                if (subtaskState == null) continue;
                managedKeyedAlternatives.add(subtaskState.getManagedKeyedState());
                rawKeyedAlternatives.add(subtaskState.getRawKeyedState());
                managedOperatorAlternatives.add(subtaskState.getManagedOperatorState());
                rawOperatorAlternatives.add(subtaskState.getRawOperatorState());
            }
            BiFunction<KeyedStateHandle, KeyedStateHandle, Boolean> keyedStateApprover = (ref, alt) -> ref.getKeyGroupRange().equals(alt.getKeyGroupRange());
            BiFunction<OperatorStateHandle, OperatorStateHandle, Boolean> operatorStateApprover = (ref, alt) -> ref.getStateNameToPartitionOffsets().equals(alt.getStateNameToPartitionOffsets());
            return new PrioritizedOperatorSubtaskState(this.resolvePrioritizedAlternatives(this.jobManagerState.getManagedKeyedState(), managedKeyedAlternatives, keyedStateApprover), this.resolvePrioritizedAlternatives(this.jobManagerState.getRawKeyedState(), rawKeyedAlternatives, keyedStateApprover), this.resolvePrioritizedAlternatives(this.jobManagerState.getManagedOperatorState(), managedOperatorAlternatives, operatorStateApprover), this.resolvePrioritizedAlternatives(this.jobManagerState.getRawOperatorState(), rawOperatorAlternatives, operatorStateApprover), this.restored);
        }

        protected <T extends StateObject> List<StateObjectCollection<T>> resolvePrioritizedAlternatives(StateObjectCollection<T> jobManagerState, List<StateObjectCollection<T>> alternativesByPriority, BiFunction<T, T, Boolean> approveFun) {
            if (alternativesByPriority == null || alternativesByPriority.isEmpty() || !jobManagerState.hasState() || jobManagerState.size() != 1) {
                return Collections.singletonList(jobManagerState);
            }
            StateObject reference = (StateObject)jobManagerState.iterator().next();
            ArrayList<StateObjectCollection<T>> approved = new ArrayList<StateObjectCollection<T>>(1 + alternativesByPriority.size());
            for (StateObjectCollection<T> alternative : alternativesByPriority) {
                if (alternative == null || !alternative.hasState() || alternative.size() != 1 || !BooleanUtils.isTrue((Boolean)approveFun.apply(reference, (StateObject)alternative.iterator().next()))) continue;
                approved.add(alternative);
            }
            approved.add(jobManagerState);
            return Collections.unmodifiableList(approved);
        }
    }
}

